// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonCommonMigration.view.error.List', {
    extend: 'Ext.grid.Panel',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_common_migration/main',

    cls: 'viison-common--grid',

    /**
     * @override
     */
    initComponent: function () {
        this.columns = this.createColumns();

        this.callParent(arguments);
    },

    /**
     * @returns {object[]}
     */
    createColumns: function () {
        return [
            {
                text: this.getViisonSnippet('errorWindow/migrationSetList/column/pluginName/text'),
                dataIndex: 'name',
                width: 150,
                sortable: false,
            },
            {
                text: this.getViisonSnippet('errorWindow/migrationSetList/column/successful/text'),
                width: 75,
                tooltip: this.getViisonSnippet('errorWindow/migrationSetList/column/successful/toolTip'),
                sortable: false,
                renderer: function (value, meta, record) {
                    return record.getMigrations().count() - record.getExecutableMigrations().length;
                },
            },
            {
                text: this.getViisonSnippet('errorWindow/migrationSetList/column/remaining/text'),
                width: 75,
                tooltip: this.getViisonSnippet('errorWindow/migrationSetList/column/remaining/toolTip'),
                sortable: false,
                renderer: function (value, meta, record) {
                    return record.getExecutableMigrations().length;
                },
            },
            {
                text: this.getViisonSnippet('errorWindow/migrationSetList/column/errorMessage/text'),
                dataIndex: 'exceptionMessage',
                flex: 1,
                sortable: false,
                renderer: function (value, meta, record) {
                    var failedMigration = record.getFailedMigration();
                    if (failedMigration) {
                        return failedMigration.get('exceptionMessage');
                    }

                    return this.getViisonSnippet('errorWindow/migrationSetList/column/errorMessage/value/noError');
                },
                scope: this,
            },
            {
                xtype: 'actioncolumn',
                width: 48,
                items: this.createActionColumnItems(),
            },
        ];
    },

    /**
     * @returns {object[]}
     */
    createActionColumnItems: function () {
        var getClassFunction = function (value, metadata, record) {
            if (record.getFailedMigration()) {
                return '';
            }

            return 'x-hidden';
        };

        return [{
            iconCls: 'sprite-magnifier',
            tooltip: this.getViisonSnippet('errorWindow/migrationSetList/actionColumn/showDetails/toolTip'),
            getClass: getClassFunction,
            handler: function (view, rowIndex, colIndex, item, ops, record) {
                Ext.Msg.alert(
                    this.getViisonSnippet('errorWindow/migrationSetList/actionColumn/showDetails/dialog/title'),
                    record.getFailedMigration().get('exceptionDetails')
                );
            },
            scope: this,
        }, {
            iconCls: 'sprite-document-copy',
            tooltip: this.getViisonSnippet('errorWindow/migrationSetList/actionColumn/showDetails/toolTip'),
            getClass: getClassFunction,
            handler: function (view, rowIndex, colIndex, item, ops, record) {
                var textArea = document.createElement('textarea');
                textArea.value = record.getFailedMigration().get('exceptionDetails');
                document.body.appendChild(textArea);
                textArea.select();

                try {
                    document.execCommand('copy');
                    Shopware.Msg.createGrowlMessage(
                        this.getViisonSnippet('errorWindow/migrationSetList/actionColumn/copyDetails/growlMessage/success/title'),
                        this.getViisonSnippet('errorWindow/migrationSetList/actionColumn/copyDetails/growlMessage/success/text'),
                        'Pickware'
                    );
                } catch (err) {
                    Shopware.Msg.createGrowlMessage(
                        this.getViisonSnippet('errorWindow/migrationSetList/actionColumn/copyDetails/growlMessage/error/title'),
                        this.getViisonSnippet('errorWindow/migrationSetList/actionColumn/copyDetails/growlMessage/error/text'),
                        'Pickware'
                    );
                }

                document.body.removeChild(textArea);
            },
            scope: this,
        }];
    },
});
