// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

/*
 * Make "order activity performed" date fields (see
 * Shopware\Plugins\ViisonCommon\Classes\Subscribers\OrderActivityPerformedDateSubscriber) read-only since they have
 * informative purpose only and saving the attribute form after some other AJAX request has caused the field to be set
 * asynchronously may cause the field to be cleared again.
 */

Ext.define('Shopware.apps.ViisonCommonOrderActivityPerformedDate.view.detail.Form', {

    override: 'Shopware.attribute.Form',

    createFields: function () {
        var fields = this.callParent(arguments);
        Ext.Array.each(fields, function (field) {
            var suffix = '_order_activity_performed_date';
            // add some gratuitous guards since some plugin developers overwrite this method to return things that are
            // clearly not fields
            if (field && field.name && field.name.substring(field.name.length - suffix.length) === suffix) {
                field.readOnly = true;
            }
        });

        return fields;
    },
});
