// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonCommonOrderDocumentTypeHider.view.batch.Form', {
    override: 'Shopware.apps.Order.view.batch.Form',

    /**
     * @override
     */
    createSettingsContainer: function () {
        var settingsFieldSet = this.callParent(arguments);

        settingsFieldSet.items.each(function (item) {
            if (item.name !== 'documentType') {
                return;
            }

            item.getStore().clearFilter(true);
            item.getStore().filter('viisonHidden', false);
        });

        return settingsFieldSet;
    },
});
