// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

/**
 * A currency formatter singleton that uses the currency information as written to
 * the smarty template in $ViisonCurrency to format values.
 */
Ext.define('Shopware.apps.ViisonCommonStatusTranslator.Translator', {

    alternateClassName: 'ViisonStatusTranslator',
    viisonConfigNamespace: 'ViisonCommonStatusTranslator',

    statics: {
        paymentStatusSnippets: ViisonCommonApp.getConfig('paymentStatusSnippets', 'ViisonCommonStatusTranslator'),
        orderStatusSnippets: ViisonCommonApp.getConfig('orderStatusSnippets', 'ViisonCommonStatusTranslator'),

        /**
         * @param name
         * @returns string
         */
        translatePaymentStatus: function (name) {
            if (ViisonStatusTranslator.paymentStatusSnippets && ViisonStatusTranslator.paymentStatusSnippets[name]) {
                return ViisonStatusTranslator.paymentStatusSnippets[name];
            }
            if (Shopware.model.PaymentStatus.prototype.snippets && Shopware.model.PaymentStatus.prototype.snippets[name]) {
                return Shopware.model.PaymentStatus.prototype.snippets[name];
            }

            return name;
        },

        /**
         * @param name
         * @returns string
         */
        translateOrderStatus: function (name) {
            if (ViisonStatusTranslator.orderStatusSnippets && ViisonStatusTranslator.orderStatusSnippets[name]) {
                return ViisonStatusTranslator.orderStatusSnippets[name];
            }
            if (Shopware.model.OrderStatus.prototype.snippets && Shopware.model.OrderStatus.prototype.snippets[name]) {
                return Shopware.model.OrderStatus.prototype.snippets[name];
            }

            return name;
        },
    },

});
