<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <meta http-equiv="content-type" content="text/html; utf-8"/>
    <title></title>
    {block name="css"}
        <style type="text/css">

            @page {
                padding: 0;
                margin: 0;
            }

            body {
                font-family: 'Helvetica Neue', Arial, sans-serif;
            }

            .cell {
                display: block;
                width: {$layout->cellWidthInMillimeters}mm;
                height: {$layout->cellHeightInMillimeters}mm;
                overflow: hidden;
                position: absolute;
            }

            .page {
                position: absolute;
                left: 0;
                top: 0;
                page-break-after: always;
                page-break-inside: avoid;
            }

            .page:last-of-type {
                /* Prevent an empty last page */
                page-break-after: auto;
            }

        </style>
    {/block}
</head>
<body>
    <div class="page">
        {* Add the item cells *}
        {for $i=0 to $items|count -1}
            {* Check for page break *}
            {if $i > 0 && i < $items|count - 1 && ($i % ($layout->columnAmount * $layout->rowAmount)) == 0}
                </div><div class="page">
            {/if}
            {assign var=cellItem value=$items[$i]}

            {* Calculate the label's left position of the label on the page *}
            {assign var=elementsAlreadyRenderedInLastRow value=($i % $layout->columnAmount)}
            {assign
                var=cellPositionLeft
                value=(
                    $elementsAlreadyRenderedInLastRow
                    *
                    ($layout->horizontalCellSpacingInMillimeters + $layout->cellWidthInMillimeters)
                    +
                    $layout->pageMarginLeftInMillimeters
                )
            }

            {* Calculate the label's top position on the page*}
            {assign var=existingLabelsInCompletelyFilledRows value=($i - $elementsAlreadyRenderedInLastRow)}
            {assign var=existingRows value=($existingLabelsInCompletelyFilledRows / $layout->columnAmount)}
            {assign var=existingRowsOnPage value=($existingRows % $layout->rowAmount)}
            {assign var=cellPositionTop
                value=(
                    $existingRowsOnPage
                    *
                    ($layout->verticalCellSpacingInMillimeters + $layout->cellHeightInMillimeters)
                    +
                    $layout->pageMarginTopInMillimeters
                )
            }

            {* Render the cell *}
            <div class="cell" style="left: {$cellPositionLeft}mm;top:{$cellPositionTop}mm;">
                {if (!empty($cellItem))}
                    {block name="cell-content"}{/block}
                {/if}
            </div>
        {/for}
    </div>
</body>
</html>
