# -*- coding: utf-8 -*-
#
# Configuration file for the Sphinx documentation builder.
#
# This file does only contain a selection of the most common options. For a
# full list see the documentation:
# http://www.sphinx-doc.org/en/master/config

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
# import os
# import sys
# sys.path.insert(0, os.path.abspath('.'))


# -- Project information -----------------------------------------------------

project = 'Shopware ERP'
copyright = 'Pickware GmbH'
author = 'Pickware GmbH'

import os
import re
import sys

code_version_regex = re.compile(
    """
        ^
        (?: \\s* protected \\s+ \\$codeVersion \\s* = \\s* )
        '
        (?P<version> [^']*)
        '
    """,
    re.X
)

def get_version_from_code_version_line(line):
    matcher = code_version_regex.search(line)
    if matcher is None:
        return None
    return matcher.groupdict().get('version')

def get_version_from_bootstrap_by_name(bootstrap_file_name):
    with open(bootstrap_file_name) as bootstrap_file:
        for line in bootstrap_file:
            maybe_code_version = get_version_from_code_version_line(line)
            if maybe_code_version is not None:
                return maybe_code_version

def get_version_from_bootstrap():
    bootstrap_file_name = os.path.join(os.path.dirname(__file__), '..', 'Bootstrap.php')
    return get_version_from_bootstrap_by_name(bootstrap_file_name)

def get_tag():
    import subprocess
    git_describe_proc = subprocess.Popen(
        ['git', 'describe', '--always'],
        stdout = subprocess.PIPE,
        stderr = subprocess.PIPE,
        cwd = os.path.join(os.path.dirname(__file__), '..')
    )
    stdout, stderr = git_describe_proc.communicate()
    if git_describe_proc.returncode != 0:
        raise RuntimeError(
            'git describe failed: ' \
                + stdout.decode(sys.stderr.encoding) \
                + stderr.decode(sys.stderr.encoding)
        )
    return stdout.rstrip(b'\n').decode(sys.stdout.encoding)

# The short X.Y version
version = get_version_from_bootstrap()
# The full version, including alpha/beta/rc tags
release = get_tag()


# -- General configuration ---------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
#
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    'sphinxcontrib.httpdomain',
    'sphinxcontrib.httpexample',
    'sphinxcontrib.phpdomain',
    'sphinx.ext.intersphinx',
    'recommonmark'
]

httpexample_scheme = 'https'

# Add any paths that contain templates here, relative to this directory.
templates_path = ['config/sphinx/_templates']

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
# source_suffix = ['.rst', '.md']
source_suffix = ['.rst', '.md']

# The master toctree document.
master_doc = 'index'

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = 'en'

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = [
    'build/**',
    'docs-gen/**',
]

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = None


# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
#html_theme = 'alabaster'

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#
# html_theme_options = {}

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']

# Prevent images from becoming clickable links automatically
html_scaled_image_link = False

# Custom sidebar templates, must be a dictionary that maps document names
# to template names.
#
# The default sidebars (for documents that don't match any pattern) are
# defined by theme itself.  Builtin themes are using these templates by
# default: ``['localtoc.html', 'relations.html', 'sourcelink.html',
# 'searchbox.html']``.
#
# html_sidebars = {}


# -- Options for Epub output -------------------------------------------------

# Bibliographic Dublin Core info.
epub_title = project

# The unique identifier of the text. This can be a ISBN number
# or the project homepage.
#
# epub_identifier = ''

# A unique identification for the text.
#
# epub_uid = ''

# A list of files that should not be packed into the epub file.
epub_exclude_files = ['search.html']

import sphinx_rtd_theme
html_theme = "sphinx_rtd_theme"
html_theme_path = [sphinx_rtd_theme.get_html_theme_path()]

# Set up PHP syntax highlights
from sphinx.highlighting import lexers
from pygments.lexers.web import PhpLexer
lexers["php"] = PhpLexer(startinline=True, linenos=1)
lexers["php-annotations"] = lexers["php"]
primary_domain = "php"

intersphinx_mapping = {
    # Ref prefix:
    'erp': (
        # Link prefix from sphinx docs to phpdoc:
        './phpdoc/',
        # The index file relative from sphinx docs source directory:
        ('build/phpdoc-indexed-for-sphinx/objects.inv'),
    ),
}
