<?php

/**
 * Main backend controller for magnalister. Initializes the magnalister app.
 */

include_once str_replace('\\', '/',dirname(__FILE__)).'/MagnalisterAbstract.php';
class Shopware_Controllers_Frontend_Magnalister extends Shopware_Controllers_Magnalister_Front_MagnalisterAbstract {
 
    /**
     * Disables output buffering in Enlight_Controller_Dispatcher_Default
     * @see Enlight_Controller_Dispatcher_Default
     * @return void
     */
    public function init() {
        // Disables output buffering
        $this->Front()->setParam('disableOutputBuffering', true);
    }
    
    /**
     * Main entry point for the magnalister app that will be loaded
     * in an iframe in the backend.
     */
    public function indexAction() {
        header('Content-Type: text/html; charset=utf-8');

        try {
            define("MLSHOPWAREREVERSION", $this->container->get('config')->get('revision'));
            define("MLSHOPWAREVERSION", $this->container->get('config')->get('version'));
        } catch (\Exception $oEx) {
        }
        $appPath = dirname(dirname(str_replace(str_replace('\\', '/',Enlight_Application::Instance()->AppPath()), '', str_replace('\\', '/', dirname(__FILE__)))));
        $_PluginPath = Enlight_Application::Instance()->AppPath($appPath) . 'Lib/Core/ML.php';
        if (!file_exists($_PluginPath) && file_exists($appPath.'/Lib/Core/ML.php')) {
            $_PluginPath = $appPath. '/Lib/Core/ML.php';
        }
        if (!file_exists($_PluginPath) && file_exists(dirname(__FILE__).'/../../../../../../../../../../magnalister/Core/ML.php')) {
            $_PluginPath = dirname(__FILE__).'/../../../../../../../../../../magnalister/Core/ML.php';
        }
        $debugPrint = '';
        
        if (file_exists($_PluginPath)) {
            require_once($_PluginPath);
            //preset http response code to 200
            http_response_code(200);
            ML::gi()->runFrontend('do');
            \MagnalisterFunctions::stop();
        } else {
            ob_start();
            var_dump($_PluginPath);
            $_path = ob_get_clean();
            $debugPrint .= trim($_path).' not found!' . "\n\n";
        }

        header('Content-Type: text/html; charset=utf-8');
        echo('<!DOCTYPE html>
            <html>
                <head>
                    <meta charset="utf-8">
                    <title>magnalister front page</title>
                </head>
                <body >
                    <pre>'.$debugPrint.'</pre> 
                </body>
            </html>
        ');
        \MagnalisterFunctions::stop();
    }
}
