<?php
/*
 * 888888ba                 dP  .88888.                    dP
 * 88    `8b                88 d8'   `88                   88
 * 88aaaa8P' .d8888b. .d888b88 88        .d8888b. .d8888b. 88  .dP  .d8888b.
 * 88   `8b. 88ooood8 88'  `88 88   YP88 88ooood8 88'  `"" 88888"   88'  `88
 * 88     88 88.  ... 88.  .88 Y8.   .88 88.  ... 88.  ... 88  `8b. 88.  .88
 * dP     dP `88888P' `88888P8  `88888'  `88888P' `88888P' dP   `YP `88888P'
 *
 *                          m a g n a l i s t e r
 *                                      boost your Online-Shop
 *
 * -----------------------------------------------------------------------------
 * (c) 2010 - 2022 RedGecko GmbH -- http://www.redgecko.de
 *     Released under the MIT License (Expat)
 * -----------------------------------------------------------------------------
 */

MLFilesystem::gi()->loadClass('Database_Model_Table_Prepare_Abstract');
class ML_Check24_Model_Table_Check24_Prepare extends ML_Database_Model_Table_Prepare_Abstract {

    protected $sTableName = 'magnalister_check24_prepare';
    protected $aFields = array ( 
        'mpID' => array (
            'isKey' => true,
            'Type' => 'int(11) unsigned', 'Null' => self::IS_NULLABLE_NO, 'Default' => NULL, 'Extra' => '', 'Comment'=>''
        ),
        'products_id' => array (
            'isKey' => true,
            'Type' => 'int(11)', 'Null' => self::IS_NULLABLE_NO, 'Default' => NULL, 'Extra' => '', 'Comment'=>''
        ),
        'ShippingTime' => array (
            'Type' => 'int(16)', 'Null' => self::IS_NULLABLE_NO, 'Default' => 0, 'Extra' => '', 'Comment'=>''
        ),
        'ShippingCost' => array (
            'Type' => 'decimal(15,4)', 'Null' => self::IS_NULLABLE_NO, 'Default' => 0, 'Extra' => '', 'Comment'=>''
        ),
        'Marke' => array (
            'Type' => 'varchar(127)', 'Null' => self::IS_NULLABLE_NO, 'Default' => '', 'Extra' => '', 'Comment'=>''
        ),
        'Hersteller_Name' => array (
            'Type' => 'varchar(127)', 'Null' => self::IS_NULLABLE_NO, 'Default' => '', 'Extra' => '', 'Comment'=>''
        ),
        'Hersteller_Strasse_Hausnummer' => array (
            'Type' => 'varchar(127)', 'Null' => self::IS_NULLABLE_NO, 'Default' => '', 'Extra' => '', 'Comment'=>''
        ),
        'Hersteller_PLZ' => array (
            'Type' => 'varchar(127)', 'Null' => self::IS_NULLABLE_NO, 'Default' => '', 'Extra' => '', 'Comment'=>''
        ),
        'Hersteller_Stadt' => array (
            'Type' => 'varchar(127)', 'Null' => self::IS_NULLABLE_NO, 'Default' => '', 'Extra' => '', 'Comment'=>''
        ),
        'Hersteller_Land' => array (
            'Type' => 'varchar(127)', 'Null' => self::IS_NULLABLE_NO, 'Default' => '', 'Extra' => '', 'Comment'=>''
        ),
        'Hersteller_Email' => array (
            'Type' => 'varchar(127)', 'Null' => self::IS_NULLABLE_NO, 'Default' => '', 'Extra' => '', 'Comment'=>''
        ),
        'Hersteller_Telefonnummer' => array (
            'Type' => 'varchar(127)', 'Null' => self::IS_NULLABLE_YES, 'Default' => '', 'Extra' => '', 'Comment'=>''
        ),
        'Verantwortliche_Person_fuer_EU_Name' => array (
            'Type' => 'varchar(127)', 'Null' => self::IS_NULLABLE_NO, 'Default' => '', 'Extra' => '', 'Comment'=>''
        ),
        'Verantwortliche_Person_fuer_EU_Strasse_Hausnummer' => array (
            'Type' => 'varchar(127)', 'Null' => self::IS_NULLABLE_NO, 'Default' => '', 'Extra' => '', 'Comment'=>''
        ),
        'Verantwortliche_Person_fuer_EU_PLZ' => array (
            'Type' => 'varchar(127)', 'Null' => self::IS_NULLABLE_NO, 'Default' => '', 'Extra' => '', 'Comment'=>''
        ),
        'Verantwortliche_Person_fuer_EU_Stadt' => array (
            'Type' => 'varchar(127)', 'Null' => self::IS_NULLABLE_NO, 'Default' => '', 'Extra' => '', 'Comment'=>''
        ),
        'Verantwortliche_Person_fuer_EU_Land' => array (
            'Type' => 'varchar(127)', 'Null' => self::IS_NULLABLE_NO, 'Default' => '', 'Extra' => '', 'Comment'=>''
        ),
        'Verantwortliche_Person_fuer_EU_Email' => array (
            'Type' => 'varchar(127)', 'Null' => self::IS_NULLABLE_NO, 'Default' => '', 'Extra' => '', 'Comment'=>''
        ),
        'Verantwortliche_Person_fuer_EU_Telefonnummer' => array (
            'Type' => 'varchar(127)', 'Null' => self::IS_NULLABLE_YES, 'Default' => '', 'Extra' => '', 'Comment'=>''
        ),
        'DeliveryMode' => array (
            'Type' => 'varchar(31)', 'Null' => self::IS_NULLABLE_NO, 'Default' => '', 'Extra' => '', 'Comment'=>''
        ),
        'DeliveryModeText' => array (
            'Type' => 'varchar(31)', 'Null' => self::IS_NULLABLE_NO, 'Default' => '', 'Extra' => '', 'Comment'=>''
        ),
        'Two_men_handling' => array (
            'Type' => 'varchar(15)', 'Null' => self::IS_NULLABLE_NO, 'Default' => '', 'Extra' => '', 'Comment'=>''
        ),
        'Installation_service' => array (
            'Type' => 'varchar(2)', 'Null' => self::IS_NULLABLE_NO, 'Default' => '', 'Extra' => '', 'Comment'=>''
        ),
        'Removal_old_item' => array (
            'Type' => 'varchar(2)', 'Null' => self::IS_NULLABLE_NO, 'Default' => '', 'Extra' => '', 'Comment'=>''
        ),
        'Removal_packaging' => array (
            'Type' => 'varchar(31)', 'Null' => self::IS_NULLABLE_NO, 'Default' => '', 'Extra' => '', 'Comment'=>''
        ),
        'Available_service_product_ids' => array (
            'Type' => 'varchar(127)', 'Null' => self::IS_NULLABLE_NO, 'Default' => '', 'Extra' => '', 'Comment'=>''
        ),
        'Logistics_provider' => array (
            'Type' => 'varchar(31)', 'Null' => self::IS_NULLABLE_NO, 'Default' => '', 'Extra' => '', 'Comment'=>''
        ),
        'Custom_tariffs_number' => array (
            'Type' => 'varchar(31)', 'Null' => self::IS_NULLABLE_NO, 'Default' => '', 'Extra' => '', 'Comment'=>''
        ),
        'Return_shipping_costs' => array (
            'Type' => 'varchar(31)', 'Null' => self::IS_NULLABLE_NO, 'Default' => '', 'Extra' => '', 'Comment'=>''
        ),
        'Verified' => array (
            'Type' => "enum('OK','ERROR','OPEN','EMPTY')", 'Null' => self::IS_NULLABLE_NO, 'Default' => 'OPEN', 'Extra' => '', 'Comment'=>''
        ),
        'PreparedTS'   => array (
            'isInsertCurrentTime' => true,
            'Type' => 'datetime', 'Null' => self::IS_NULLABLE_YES, 'Default' => NULL, 'Extra' => '', 'Comment'=>''
        ),
    );
	
    protected $aTableKeys=array(
        'UniqueEntry' => array('Non_unique' => '0', 'Column_name' => 'mpID, products_id'),
    );
	
    public function __construct() {
        parent::__construct();
    }
    
    protected function setDefaultValues() {
        try {
            $sId = MLRequest::gi()->get('mp');
            if (is_numeric($sId)) {
                $this->set('mpid', $sId);
            }
        } catch (Exception $oEx) {
            
        }
        return $this;
    }
	
}
