<?php
/**
 * 888888ba                 dP  .88888.                    dP                
 * 88    `8b                88 d8'   `88                   88                
 * 88aaaa8P' .d8888b. .d888b88 88        .d8888b. .d8888b. 88  .dP  .d8888b. 
 * 88   `8b. 88ooood8 88'  `88 88   YP88 88ooood8 88'  `"" 88888"   88'  `88 
 * 88     88 88.  ... 88.  .88 Y8.   .88 88.  ... 88.  ... 88  `8b. 88.  .88 
 * dP     dP `88888P' `88888P8  `88888'  `88888P' `88888P' dP   `YP `88888P' 
 *
 *                          m a g n a l i s t e r
 *                                      boost your Online-Shop
 *
 * -----------------------------------------------------------------------------
 * $Id$
 *
* (c) 2010 - 2018 RedGecko GmbH -- http://www.redgecko.de
 *     Released under the MIT License (Expat)
 * -----------------------------------------------------------------------------
 */
MLFilesystem::gi()->loadClass('Productlist_Controller_Widget_ProductList_Selection');
class ML_Etsy_Controller_Etsy_Prepare extends ML_Tabs_Controller_Widget_Tabs_Filesystem_Abstract {

    public static function getTabTitle() {
        return MLI18n::gi()->get('ML_GENERIC_PREPARE');
    }

    public static function getTabActive() {
        return MLModule::gi()->isConfigured();
    }

    public static function getTabDefault() {
        return true;
    }
    
    public function __construct() {
        MLSetting::gi()->add('aJs', 'etsy.processingProfile.js');
        parent::__construct();
        try {
            $mExecute = $this->oRequest->get('view');
            if ($mExecute == 'unprepare') {
                $oModel = MLDatabase::factory('etsy_prepare');
                $oList = MLDatabase::factory('selection')->set('selectionname', 'apply')->getList();
                foreach ($oList->get('pid') as $iPid) {
                    $oModel->init()->set('products_id', $iPid)->delete();
                }
            } elseif (
                is_array($mExecute)
                && !empty($mExecute)
                && (
                    in_array('reset_whenmade', $mExecute)
                )
            ) {
                $oModel = MLDatabase::factory('etsy_prepare');
                $oList = MLDatabase::factory('selection')->set('selectionname', 'apply')->getList();
                foreach ($oList->get('pid') as $iPid) {
                    $oModel->init()->set('products_id', $iPid);
                    if (in_array('reset_whenmade', $mExecute)) {
                        $oModel->set('whenmade', MLDatabase::factory('preparedefaults')->getValue('whenmade'));
                    }
                    $oModel->save();
                }
            }
        } catch (Exception $oEx) {
            //            echo $oEx->getMessage();
        }
    }


}
