<?php
/*
 * 888888ba                 dP  .88888.                    dP
 * 88    `8b                88 d8'   `88                   88
 * 88aaaa8P' .d8888b. .d888b88 88        .d8888b. .d8888b. 88  .dP  .d8888b.
 * 88   `8b. 88ooood8 88'  `88 88   YP88 88ooood8 88'  `"" 88888"   88'  `88
 * 88     88 88.  ... 88.  .88 Y8.   .88 88.  ... 88.  ... 88  `8b. 88.  .88
 * dP     dP `88888P' `88888P8  `88888'  `88888P' `88888P' dP   `YP `88888P'
 *
 *                          m a g n a l i s t e r
 *                                      boost your Online-Shop
 *
 * -----------------------------------------------------------------------------
 * (c) 2010 - 2023 RedGecko GmbH -- http://www.redgecko.de
 *     Released under the MIT License (Expat)
 * -----------------------------------------------------------------------------
 */

# vgl auch: lib/classes/ComparisonShopping/ComparisonShoppingListings.php

if (!defined('_ML_INSTALLED'))
    throw new Exception('Direct Access to this location is not allowed.');
require_once(DIR_MAGNALISTER_MODULES.'ebay/classes/InventoryView.php');
require_once(DIR_MAGNALISTER_MODULES.'ebay/classes/DeletedView.php');

$sController = MLRequest::gi()->get('controller');
if ( strpos($sController, '_deleted') ) {
    $dV = new DeletedView(MLModule::gi()->getMarketPlaceId());
        $dV->includeView('widget_listings_misc_listingbox');
        echo $dV->renderView();
	
} else {
    $iV = new InventoryView(MLModule::gi()->getMarketPlaceId());
        $iV->includeView('widget_listings_misc_listingbox');
	echo $iV->renderView();
}
