## 5.20.2.55

### en

* This plugin version is compatible with Shopware versions 5.5 and above, and contains all changes from version 5.20.2.0.

### de

* Diese Plugin-Version ist kompatibel mit Shopware-Versionen ab 5.5 und enthält alle Änderungen von Version 5.20.2.0.


## 5.20.1

### en

**Bug fixes:**

* The automatic selection of the next order for picking as well as preparing batch picking no longer runs into timeouts if many orders are available for picking.

### de

**Fehlerbehebungen:**

* Die automatische Auswahl der nächsten Bestellung zur Kommissionierung sowie das Vorbereiten einer Sammelkomissionierung führen nun nicht mehr zu Timeouts, wenn sehr viele Bestellungen kommissionierbar sind.


## 5.20.0

### en

**New features and improvements:**

* Prepares the plugin for future updates of the Picking app.

**Bug fixes:**

* Fixes an error that could cause not all pick profiles to be visible in the order overview.

### de

**Neue Funktionen und Verbesserungen:**

* Bereitet das Plugin für zukünftige Updates der Versand-App vor.

**Fehlerbehebungen:**

* Behebt einen Fehler, der dazu führen konnte, dass nicht alle Pickprofile in der Bestellübersicht sichtbar waren.


## 5.19.0

### en

**New features and improvements:**

* Prepares the plugin for future updates of the Picking app and the Stocking app.

**Bug fixes:**

* Restores compatibility with PHP 8.
* Fixes an error that could occur when reserving stock for an order that was previously deferred.

### de

**Neue Funktionen und Verbesserungen:**

* Bereitet das Plugin für zukünftige Updates der Versand-App und Lager-App vor.

**Fehlerbehebungen:**

* Stellt die Kompatibilität mit PHP 8 wieder her.
* Behebt einen Fehler, der beim Reservieren von Bestand auftreten konnte, wenn eine zurückgestellte Bestellung wiederaufgenommen wurde.


## 5.18.2

### en

**Bug fixes:**

* Fixes compatibility with Shopware >= 5.7.6.

### de

**Fehlerbehebungen:**

* Stellt die Kompatibilität mit Shopware >= 5.7.6 her.


## 5.18.1

### en

**Bug fixes:**

* Fixes an error in the order document preview.

### de

**Fehlerbehebungen:**

* Behebt einen Fehler in der Vorschau von Bestelldokumenten.


## 5.18.0

### en

**New features and improvements:**

* Orders can now be found by entering "Required information upon reducing stock" in the global search as well as within the order list search (only for Shopware 5.5 and later) in the Shopware backend.

### de

**Neue Funktionen und Verbesserungen:**

* Bestellungen können nun anhand von "Beim Auslagern erforderliche Informationen" in der globalen Suche sowie innerhalb der Liste der Bestellungen (nur für Shopware 5.5 und neuer) im Shopware-Backend gefunden werden.


## 5.17.1

### en

**Bug fixes:**

* Fixes a compatibility issue with PHP 7.4.21 and PHP 8.0.8.

### de

**Fehlerbehebungen:**

* Behebt ein Kompatibilitätsproblem mit PHP 7.4.21 und PHP 8.0.8.


## 5.17.0

### en

**New features and improvements:**

* Enables compatibility with Shopware 5.7.

### de

**Neue Funktionen und Verbesserungen:**

* Stellt die Kompatibilität mit Shopware 5.7 her.


## 5.16.0

### en

**New features and improvements:**

* Custom attributes of type "date" (`DATE`) or "date / time" (`DATETIME`) can now be used in pick profile rules.
* New operators "in X days", "in min. X days" and "in max. X days" are now available in pick profile rules.

**Bug fixes:**

* Creating an order document via the REST API no longer fails, if more than one document of the same type already exists for the order.
* The footer is on partial delivery notes is now displayed correctly.
* Assigned batch picking boxes are now always cleared when marking an order as "completely delivered".
* The filters "Visible in Picking app" and "Waiting for stock" in the backend's order list now work in conjunction.
* Automatic status emails for order status "completely delivered" now always correctly detect partial deliveries.

### de

**Neue Funktionen und Verbesserungen:**

* Individuelle Attribute vom Typ "Datum" (`DATE`) oder "Datum / Zeit" (`DATETIME`) können nun in Pickprofilregeln verwendet werden.
* In Pickprofilregeln stehen nun neue Operatoren "in X Tagen", "in min. X Tagen" und "in max. X Tagen" zur Verfügung.

**Fehlerbehebungen:**

* Das Erstellen von Dokumenten über die REST API schlägt nun nicht mehr fehl, falls für die Bestellung bereits mehr als ein Dokument des selben Typs existiert.
* Die Fußzeile von Teillieferscheinen wird nun korrekt dargestellt.
* Zugeordnete Kommissionierkisten werden nun immer freigegeben, sobald eine Bestellung in den Status "komplett ausgeliefert" gesetzt wird.
* Die Filter "Sichtbar in Versand-App" und "Wartet auf Wareneingang" in der Bestellübersicht im Backend funktionieren nun zusammen.
* Automatische Status-E-Mails für den Bestellstatus "komplett ausgeliefert" erkennen nun alle Teillieferungen.


## 5.15.1

### en

* Fixes a bug which prevented the successful order modification when the order status mail failed to be sent.

### de

* Behebt einen Fehler, der die erfolgreiche Bestelländerung verhinderte, wenn die Bestellstatus-Mail nicht gesendet werden konnte.


## 5.15.0

### en

**New features and improvements:**

* Prepares the plugin for future updates of the Picking app and the Stocking app.

### de

**Neue Funktionen und Verbesserungen:**

* Bereitet das Plugin für zukünftige Updates der Versand-App und Lager-App vor.


## 5.14.3

### en

* Fixes an error that appeared in the backend when creating new products.

### de

* Behebt ein Fehler, der beim Erstellen von neuen Artikeln im Backend angezeigt wurde.


## 5.14.2

### en

* Fixes a bug which under certain circumstances caused the product searches in the Inventory app to not work correctly.

### de

* Behebt einen Fehler, der unter bestimmten Umständen dazu führte, dass die Artikelsuche in der Lager-App nicht korrekt funktionierte.


## 5.14.1

### en

* Fixes a bug which under certain circumstances caused the loading of orders in the shopware backend to be slow.

### de

* Behebt einen Fehler, der unter Umständen dazu führte, dass das Laden der Bestellungen im Shopware-Backend langsam war.


## 5.14.0

### en

* Fixes a bug which could result in an order being displayed as "visible in Picking app" in the Shopware backend although it contained order items for which there was insufficient stock for picking.
* Improves the performance of product searches in the Inventory app (Inventory app version >= 5.6.0).
* The field for selecting additional information that is required when releasing stock is no longer displayed in the Showpare backend, if the product's stock is not managed by Pickware.
* Improves the compatiblity with other plugins that make extra variables available in document templates.

### de

* Behebt einen Fehler, der unter Umständen dazu führte, dass im Shopware-Backend eine Bestellung als "in der Versand-App angezeigt" dargestellt wurde, obwohl sie Positionen enthielt, für die nicht ausreichend Bestand zur Kommissionierung vorhanden war.
* Verbessert die Geschwindigkeit der Artikelsuche in der Lager-App (Lager-App-Version >= 5.6.0).
* Das Feld zur Auswahl von bei der Auslagerung zusätzlich erforderlichen Informationen wird nun nicht mehr im Shopware-Backend angezeigt, wenn der Artikel nicht bestandsgeführt ist.
* Verbessert die Kompatibilität mit anderen Plugins, die zusätzliche Variablen in Dokumententemplates zur Verfügung stellen.


## 5.13.3

### en

* Improves the readability of barcodes on invoices and delivery notes.

### de

* Verbessert die Lesbarkeit von Barcodes auf Rechnungen und Lieferscheinen.


## 5.13.2

### en

* Fixes a bug where, for address labels, addresses could not be separated into street names and house numbers if the street name began with "No".

### de

* Behebt einen Fehler, durch den bei Adressetiketten Adressen nicht in Straßennamen und Hausnummern aufgeteilt werden konnten, wenn der Straßennamen mit "No" beginnt.


## 5.13.1

### en

* Fixes a bug that could cause the Picking app and the Inventory app to crash when used on iOS 13.1.

### de

* Behebt einen Fehler, der unter Umständen zum Absturz der Versand-App und der Lager-App führen konnte, wenn diese auf iOS 13.1 verwendet wurden.


## 5.13.0

### en

**Note: In order to update to this version, Version 6.2.2 or later of the plugin _Shopware ERP powered by Pickware_ must be installed.**

* Allows the selection of the desired bin location if the picking process is canceled via the Shopware-Backend.

### de

**Hinweis: Es muss mindestens Version 6.2.2 des Plugins _Shopware ERP powered by Pickware_ installiert sein, um ein Update auf diese Version durchführen zu können.**

* Ermöglicht die Auswahl des gewünschten Lagerplatzes, wenn der Kommissioniervorgang über das Shopware-Backend abgebrochen wird.


## 5.12.0

### en

* Enables compatibility with Shopware 5.6.
* Adds the new user resource `pickware_wms_picking` with the privileges `select_any_order_for_picking` and `take_over_locked_order_for_picking` to the Shopware user administration.
* Adds the new user resource `pickware_wms_stocking` with the privileges `edit_item_details`, `override_suggested_bin_locations` and `view_purchase_prices` to the Shopware user administration.
* Fixed a bug that caused remaining items to be displayed on the delivery note when creating delivery notes in the backend.

### de

* Stellt die Kompatibilität mit Shopware 5.6 her.
* Fügt die neue Benutzer-Ressource `pickware_wms_picking` mit den Privilegien `select_any_order_for_picking` und `take_over_locked_order_for_picking` zur Shopware Benutzerverwaltung hinzu.
* Fügt die neue Benutzer-Ressource `pickware_wms_stocking` mit den Privilegien `edit_item_details`, `override_suggested_bin_locations` und `view_purchase_prices` zur Shopware Benutzerverwaltung hinzu.
* Behebt einen Fehler, der dazu führte, dass bei der Erstellung von Lieferscheinen im Backend verbleibende Positionen auf dem Lieferschein angezeigt wurden.


## 5.11.0

### en

* Adds a new operators "does not start with" and "does not end with" for pick profile rules.
* Fixes a bug that resulted in an error when evaluating the order filter of a pick profile that contained more than one category filter.

### de

* Fügt neue Operatoren "beginnt nicht mit" und "endet nicht mit" für Pickprofilregeln hinzu.
* Behebt einen Fehler, der dazu führte, dass der Bestellfilter nicht ausgewertet werden konnte, wenn das Pickprofil mehr als einen Kategorienfilter enthielt.


## 5.10.2

### en

* Fixes a bug which prevented variants from being re-generated.

### de

* Behebt einen Fehler, durch den die Neugenerierung von Varianten fehlschlug.


## 5.10.1

### en

**Note: In order to update to this version, Version 6.2.0 or later of the plugin _Shopware ERP powered by Pickware_ must be installed.**

* Moves the backend stock-take functionality out of this plugin and into _Shopware ERP powered by Pickware_.
* Fixes a bug which could cause stock entry inconsistencies when stock entries for the same item were written at the exact same time by different users.

### de

**Hinweis: Es muss mindestens Version 6.2.0 des Plugins _Shopware ERP powered by Pickware_ installiert sein, um ein Update auf diese Version durchführen zu können.**

* Verschiebt die Backend-Inventurfunktion aus diesem Plugin nach _Shopware ERP powered by Pickware_.
* Behebt einen Fehler, durch den es zu fehlerhaften Bestandseinträgen kommen konnte, wenn Bestände von mehreren Benutzern gleichzeitig für den gleichen Artikel verändert wurden.


## 5.10.0

### en

* Product variant templates can now be configured to activate the field "Hide in Picking app" of variants generated from it.
* Fixes a bug that prevented orders from being listed in the Picking app eventhough the order's dispatch method was exempt from the stock based order filter.

### de

* Variantenvorlagen können nun so konfiguriert werden, dass bei daraus generierte Varianten das Feld “In der Versand-App ausblenden” aktiviert ist.
* Behebt einen Fehler, der dazu führte, dass Bestellungen nicht in der Versand-App angezeigt wurden, obwohl ihre Versandarten vom bestandsbasierten Filtern ausgeschlossen waren.


## 5.9.0

### en

* Adds a new configuration for selecting dispatch methods, for which a return label is automatically created and printed upon picking a respective order (Picking app version >= 5.5.0). Please note that this feature is currently limited to dispatch methods configured for label creation via one of the plugins "DHL Adapter powered by Pickware", "DPD Adapter powered by Pickware" and "PostNL Adapter powered by Pickware".
* Orders can now also be filtered with pick profiles according to the field "order time" of an order. The respective date is compared relatively to the current time, which the filter is evaluated at.
* Fixes a bug that caused the index of remaining positions on partial delivery notes to be wrong.
* Fixes a bug that caused stock to be cleared twice when an order that has already been picked was marked as shipped via the Shopware backend or the Pickware POS app. Please note that this fix only works if at least version 6.1.3 of the plugin "Shopware ERP powered by Pickware" is installed.

### de

* Fügt ein neues Konfigurationsfeld zur Auswahl von Versandarten hinzu, für die nach Kommissionierung einer entsprechenden Bestellung automatisch ein Retourenlabel erstellt und gedruckt werden soll (Versand-App-Version >= 5.5.0). Bitte beachten Sie, dass dieses Feature aktuell auf solche Versandarten eingeschränkt ist, für die die Labelerzeugung mittels einem der Plugins "DHL Adapter powered by Pickware", "DPD Adapter powered by Pickware" und "PostNL Adapter powered by Pickware" konfiguriert ist.
* Bestellungen können mit Pickprofilen nun auch nach den Feldern "Bestellzeit" einer Bestellung gefiltert werden. Das entsprechende Datum wird realativ mit der aktuellen Zeit der Filterauswertung verglichen.
* Behebt einen Fehler, der verursachte, dass der Index von ausstehenden Positionen auf Teillieferscheinen falsch war.
* Behebt einen Fehler, der dazu führte, dass Bestand doppelt ausgebucht wurde, wenn eine bereits kommissionierte Bestellung über das Backend oder die Pickware POS-App als ausgeliefert markiert wurde. Bitte beachten Sie, dass diese Fehlerbehebung nur dann funktioniert, wenn mindestens Version 6.1.3 des Plugins "Shopware ERP powered by Pickware" installiert ist.


## 5.8.1

### en

* Fixes a bug that could lead to the shop not being available after downloading version 5.8.0.

### de

* Behebt einen Fehler, der unter Umständen dazu führen konnte, dass der Shop nach Download von Version 5.8.0 nicht mehr erreichbar war.


## 5.8.0

### en

**Note: In order to update to this version, Version 6.0.0 or later of the plugin _Shopware ERP powered by Pickware_ must be installed.**

* Enables compatibility with Shopware ERP powered by Pickware version 6.0.0.
* Removes barcode label printing for items and bin locations, as well as the return shipment management features. These features are now part of the plugin _Shopware ERP powered by Pickware_.
* All existing return shipments in status "Received" will have their status updated to "Completed".
* Fixes a bug that prevented the total of a supplier order from being updated when stocking one of its items with a new purchase price.
* Adds support for stocking supplier orders in foreign currencies.

### de

**Hinweis: Es muss mindestens Version 6.0.0 des Plugins _Shopware ERP powered by Pickware_ installiert sein, um ein Update auf diese Version durchführen zu können.**

* Stellt die Kompatibilität mit Shopware ERP powered by Pickware Version 6.0.0 her.
* Entfernt die Funktionen zum Druck von Artikel- und Lagerplatzetiketten sowie die Retourenverwaltung. Diese Funktionen sind jetzt Bestandteil des Plugins _Shopware ERP powered by Pickware_.
* Alle bestehenden Retouren im Status "Eingangen" erhalten den neuen Status "Storniert".
* Behebt einen Fehler, der verhinderte, dass der Gesamtbetrag einer Lieferantenbestellung aktualisiert wurde, wenn eine der Bestellpositionen mit einem geänderten Einkaufspreis eingelagert wurde.
* Fügt Unterstützung für das Einlagern von Lieferantenbestellungen in Fremdwährungen hinzu.


## 5.7.0

### en

* Adds a new order field "Internal picking instructions" which is displayed in the Picking app while picking an order (app version >= 5.3.0).
* Adds a new product attribute "Internal picking instructions" which is displayed in the Picking app while picking an order (app version >= 5.3.0).
* Fixes a bug that prevented the Picking and Inventory apps from correctly sorting the products by the configured field.
* Fixes a bug that prevent the Picking app from creating DHL shipping labels.

### de

* Fügt Bestellungen ein neues Feld "Interne Pick-Anweisungen" hinzu, welches in der Versand-App bei der Kommissionierung angezeigt wird (App-Version >= 5.3.0).
* Fügt ein neues Artikelattribut "Interne Pick-Anweisungen" hinzu, welches in der Versand-App bei der Kommissionierung angezeigt wird (App-Version >= 5.3.0).
* Behebt einen Fehler, der dazu führte, dass Artikel in der Versand- sowie in der Lager-App nicht nach dem konfigurierten Feld sortiert waren.
* Behebt einen Fehler, der dazu führte, dass die Versand-App keine DHL-Versandetiketten mehr erstellen konnte.


## 5.6.2

### en

* Fixes an error that caused the plugin update to abort with an error if a pick profile did not have any rules.

### de

* Behebt einen Fehler, der dazu führte, dass das Plugin-Update mit einem Fehler abgebrochen wurde, wenn ein Pick-Profil keine Regeln besaß.


## 5.6.1

### en

* Fixes a bug in the configuration of pick profile that prevented a multi selection of values in a filter rule from being displayed correctly.

### de

* Behebt einen Fehler in der Konfiguration von Pickprofilen, der dazu führte, dass eine Mehrfachauswahl von Werten in einer Filterregel nicht korrekt angezeigt wurde.


## 5.6.0

### en

* Adds a new operators "is empty", "is not empty", "is defined" and "is not defined" for pick profile rules.
* Adds a searchbar to the stock-take-export window.
* Improves the performance of loading bin locations for stocktaking in the Inventory app.
* Removes the possibility to select the order status in the configuration of pick profile rules. Existing rules, which use the order status, are migrated automatically.
* Fixes picking box label printing with custom label formats.
* Fixes a bug that could prevent pick profile order filters from being evaluated correctly.

### de

* Fügt neue Operatoren "ist leer", "ist nicht leer", "hat einen Wert", "hat keinen Wert" für Pickprofilregeln hinzu.
* Fügt dem Inventurexport-Fenster eine Suchleiste hinzu.
* Verbessert die Geschwindigkeit des Ladens von Lagerplätzen für die Inventur in der Lager-App.
* Entfernt die Möglichkeit, in der Konfiguration von Pickprofilen Regeln auf Basis des Bestellstatus zu definieren. Bestehende Regeln, welche den Bestellstatus verwenden, werden automatisch migriert.
* Behebt einen Fehler, durch den Kommissionierkistenetiketten nicht in benutzerdefinierten Formaten gedruckt werden konnten.
* Behebt einen Fehler, der unter Umständen dazu führen konnte, dass Bestellfilter von Pickprofilen nicht korrekt ausgewertet wurden.


## 5.5.0

### en

* Improves the configuration and visualization of pick profiles.
* Adds a new operator "does not contain" for pick profile rules.
* Adds a new filter "Visible in Picking app" to the filter list of the order overview window.
* Adds an incompatibility warning for plugin "Automatic E-Mail Delivery".

### de

* Verbessert die Konfiguration und Darstellung von Pickprofilen.
* Fügt die einen neuen Operator "enthält nicht" für Pickprofilregeln hinzu.
* Ergänzt die Filterliste der Bestellübersicht um einen neuen Filter "Sichtbarkeit in Versand-App".
* Fügt einen Inkompatibilitätshinweis für das Plugin "Automatischer E-Mailversand" hinzu.


## 5.4.0

### en

* Adds support for showing the remaining items on a partial delivery note.
* Fixes a bug that may have prevented invoices from being sent automatically via e-mail.
* Fixes a bug where the document path was not resolved correctly when Shopware was installed via Composer.

### de

* Fügt die Möglichkeit hinzu, auf Teillieferscheinen verbleibende Positionen anzuzeigen.
* Behebt einen Fehler, der unter Umständen den automatischen Versand von Rechnungen per E-Mail verhinderte.
* Behebt ein Problem, durch das der Dokumentenpfad nicht korrekt aufgelöst wurde, wenn Shopware per Composer installiert wurde.


## 5.3.1

### en

* Backend stock-takes are now created in batches, which prevents problems with long-running stock-takes causing timeout errors.

### de

* Backend-Inventuren im Inventurexport-Fenster werden nun in kleineren Verarbeitungsblöcken geschrieben, um Timeout-Fehler beim Nullen von Inventurposten zu verhindern.


## 5.3.0

### en

* Orders can now also be filtered with pick profiles according to the fields "Comment", "Internal comment" and "Your comment" of an order.
* Fixes a bug that caused items marked as hidden in the Picking App to be shown in the batch picking and pick-to-box modes.

### de

* Bestellungen können mit Pickprofilen nun auch nach den Feldern "Kommentar", "Interner Kommentar" und "Dein Kommentar" einer Bestellung gefiltert werden.
* Behebt einen Fehler, durch den als “in der Versand-App ausblenden” markierte Artikel in der rollenden- und Sammelkommissionierung dennoch angezeigt wurden.


## 5.2.3

### en

* Fixes a bug that caused the pick profile setting "Excluded shipping methods" to be ignored when filtering orders.
* Fixes a bug that caused a return shipment to not appear in an order when the associated user was deleted
* Now automatically selects the last selected pick profile when opening the order list.

### de

* Behebt einen Fehler, der dazu führte, dass die Pickprofil-Einstellung "Ausgenommene Versandarten" beim Filtern von Bestellungen ignoriert wurde.
* Behebt einen Fehler, der dazu führte, dass eine Rücksendung in einer Bestellung nicht angezeigt wurde, wenn der dazugehörige Benutzer gelöscht wurde.
* Wählt beim Öffnen der Bestellliste nun automatisch das letzte gewählte Pickprofil aus.


## 5.2.2

### en

* Improves the performance of the pick profile order filter.

### de

* Verbessert die Geschwindigkeit des Bestellfilters der Pickprofile.


## 5.2.1

### en

* Fixes a bug that could cause the Inventory app to crash.

### de

* Behebt einen Fehler, der unter Umständen dazu führen konnte, dass die Lager-App abstürzte.


## 5.2.0

### en

* Improves the stocktake export window by adding the tab "Pending" which displays all article-bin-location-combinations without recent stocktake entries.
* Allows you to set the stock of all article-bin-location-combinations not counted in the selected time period to 0.
* Improves the display of the stocktake entries in the stocktake export.
* Allows to reprint existing order document (invoices, delivered notes etc.) in the Picking app (app version >= 5.2.0).
* All stocktake entries of a product are now logically grouped into a single entry in the stocktake export.
* Fixes a bug in label printing for picking boxes that caused an incorrect template to be selected when printing.
* Adds a new configuration parameter "Display expected stock on stock take" to set whether a stock take should display the expected stock of an item in a bin location (both in the backend and in app version >= 5.1.0).
* Changes the order of products in the stocktake list view of the Stocking app. Products are now sorted by bin location code (app version >= 5.1.0).

### de

* Erweitert den Inventurexport im Backend, um den Tab “Ungezählt”. In diesem werden alle im ausgewählten Zeitraum nicht gezählten Artikel-Lagerplatz-Kombinationen angezeigt.
* Ermöglicht den Bestand aller im ausgewählten Zeitraum nicht gezählten Artikel-Lagerplatz-Kombinationen auf 0 zu setzen.
* Verbessert die Darstellung der Inventureinträge im Inventurexport.
* Ermöglicht es, Bestelldokumente (Rechnungen, Lieferscheine etc.) in der Versand-App erneut zu drucken (App-Version >= 5.2.0).
* Im Inventurexport werden nun alle Einträge eines Artikels zu einem einzigen logischen Eintrag gruppiert.
* Behebt einen Fehler im Etikettendruck für Kommisionierkisten, das dazu führte, das beim Druck eine falsche Vorlage ausgewählt wurde.
* Fügt einen neuen Konfigurationsparameter "Erwarteten Lagerbestand bei Inventur anzeigen" hinzu, um einzustellen, ob bei einer Inventur der zu erwartende Lagerbestand eines Arikels auf einem Lagerplatz angezeigt wird (sowohl im Backend als auch in App-Version >= 5.1.0).
* Ändert die Reihenfolge der Artikel in der Inventuransicht in der Lager-App. Artikel werden nun nach Lagerplatzcode sortiert (App-Version >= 5.1.0).


## 5.1.4

### en

* Fixes a bug the lead to orders being listed in the Shopware backend order list as visible in the Picking app, even though they contained order items, whose stock is not sufficient for picking.

### de

* Behebt einen Fehler, der dazu führte, dass in der Liste der Bestellungen im Shopware-Backend eine Bestellung als in der Versand-App angezeigt dargestellt wurde, obwohl sie Positionen enthielt, für die nicht ausreichend Bestand vorhanden war.


## 5.1.3

### en

* Fixes a bug that prevented orders from being marked as prioritized in the Picking app even though their dispatch method was configured as prioritized in the selected pick profile.

### de

* Behebt einen Fehler, der dazu führte, dass Bestellungen nicht als priorisiert in der Versand-App hervorgehoben wurden, obwohl ihre Versandart im ausgewählten Pickprofil als priorisiert konfiguriert wurde.


## 5.1.2

### en

* Fixes an error that prevented orders from being picked when using Shopware versions < 5.2.17.

### de

* Behebt einen Fehler, der unter Shopware < 5.2.17 verhinderte, dass Bestellungen in der Versand-App kommissioniert werden konnten.


## 5.1.1

### en

* Fixes an error that caused some files to not being loaded in combination with the ionCube loader.

### de

* Behebt einen Fehler, der dazu führte, dass bestimmte Dateien durch den ionCube loader nicht geladen wurden.


## 5.1.0

### en

* It is now possible configure multiple pick profiles via "Settings" > "Pick profiles", including the definition of custom rules for filtering orders, which should be listed in the Picking app. The pick profile selection in the Picking app is available starting with version 5.1.0.
* Adds support for a better comparison of order data upon starting to pick an order in the Picking app (app version >= 5.1.0).

### de

* Ab sofort können unter "Einstellungen" > "Pickprofile" verschiedene Pickprofile konfiguriert werden, unter anderem mit eigenen Regeln zum Filtern von Bestellungen, welche zum Kommissionieren in der Versand-App angezeigt werden sollen. Die Auswahl des Pickprofils steht ab Version 5.1.0 der Versand-App zur Verfügung.
* Unterstützt nun einen besseren Abgleich der Daten einer Bestellung mit der Versand-App beim Starten der Kommissionierung (App-Version >= 5.1.0).


## 5.0.3

### en

* Fixes a bug that lead to wrong quantities on delivery notes for partial shipments.

### de

* Behebt einen Fehler, der dazu führte, dass auf Lieferscheinen von Teillieferungen falsche Mengen angezeigt wurden.


## 5.0.2

### en

* Improves the error message that is shown when trying to log in using the Picking or Inventory app in a version older than 5.0.0.

### de

* Verbessert die Fehlermeldung, die angezeigt wird, wenn man versucht sich mit einer älteren Version als 5.0.0 der Versand- oder Lager-App einzuloggen.


## 5.0.1

### en

* Fixes an issue with Pickware device licensing which prevented devices from logging in under certain circumstances.

### de

* Behebt ein Problem mit der Pickware-Geräteverwaltung, durch das sich Geräte unter Umständen nicht mehr einloggen konnten.


## 5.0.0

### en

**Note: In order to update to this version, Version 5.0.0 or later of the plugin _Shopware ERP powered by Pickware_ has to be installed.**

* Enables compatibility with Shopware 5.5.

### de

**Hinweis: Es muss mindestens Version 5.0.0 des Plugins "Shopware ERP powered by Pickware" installiert sein, um ein Update auf diese Version durchführen zu können.**

* Stellt die Kompatibilität mit Shopware 5.5 her.


## 4.10.3

### en

* Fixes a bug that could have caused the Shopware backend to not be available anymore under some circumstances.

### de

* Behebt einen Fehler, der unter Umständen dazu führen konnte, dass das Backend nicht mehr erreichbar war.


## 4.10.2

### en

* Fixes a bug that could have caused the Shopware backend to not be available anymore under some circumstances.

### de

* Behebt einen Fehler, der unter Umständen dazu führen konnte, dass das Backend nicht mehr erreichbar war.


## 4.10.1

### en

* Fixes a bug that prevented additional item information, which was collected during picking, from being saved correctly.

### de

* Behebt einen Fehler, der dazu führte, dass zusätzliche, beim Kommissionieren erfasste Artikelinformationen nicht korrekt gespeichert wurden.


## 4.10.0

### en

* Adds support for UPC-A barcodes to the barcode label printing.
* Improves the compatibility with plugin "EasyCoupon" by Shop Inventors (Net Inventors GmbH).

### de

* Fügt die Unterstütztung für UPC-A-Barcodes im Etikettendruck hinzu.
* Verbessert die Kompatibilität zum Plugin "EasyCoupon" von Shop Inventors (Net Inventors GmbH).


## 4.9.2

### en

* Fixes a bug that might have prevented some orders from being listed in the Picking app, because the stock of their items was falsely identified as not sufficient for picking.

### de

* Behebt einen Fehler, der unter Umständen dazu führte, dass Bestellungen nicht in der Versand-App angezeigt wurden, da der Bestand der enthaltenen Positionen irrtümlicherweise nicht als ausreichend erkannt wurde.


## 4.9.1

### en

* Fixes a bug that lead to a crash in the Picking app.
* Fixes a bug that occurred during picking in the Picking app.

### de

* Behebt einen Fehler, der zum Absturz der Versand-App geführt hat.
* Behebt einen Fehler, der beim Kommissionieren in der Versand-App auftrat.


## 4.9.0

### en

* Prepares the plugin for version 4.7.0 of the Picking app.

### de

* Bereitet das Plugin für Version 4.7.0 der Versand-App vor.


## 4.8.0

### en

* Prepares the plugin for version 4.6.0 of the Picking app.
* Improves compatibility with Shopware 5.5.

### de

* Bereitet das Plugin für Version 4.6.0 der Versand-App vor.
* Verbessert die Kompatibilität mit Shopware 5.5.


## 4.7.0

### en

* Adds a new option "Only print shipping labels" to configuration field "Picking - Printing of documents". In order for this feature to work properly, at least version 4.5.0 of the Picking app is required.

### de

* Fügt dem Konfigurationsfeld "Versand - Dokumentendruck" eine neue Option "Nur Versandetiketten drucken" hinzu. Für eine korrekte Funktionsweise der neuen Option wird mindestens Version 4.5.0 der Versand-App benötigt.


## 4.6.2

### en

* Fixes a problem that caused mail creation to fail for language sub shops in Shopware version 5.4.3.

### de

* Behebt ein Problem beim Erstellen von E-Mails für Sprach-Sub-Shops in Shopware 5.4.3.


## 4.6.1

### en

* Fixes a bug that might have occured during installation of version 4.6.0.

### de

* Behebt einen Fehler, der unter Umständen bei der Installation von Version 4.6.0 auftrat.

## 4.6.0

### en

* Prepares the plugin for version 4.4.0 of the Picking app as well as for version 4.1.0 of the Inventory app.
* Fixes a bug in the REST API in Shopware versions prior 5.2.8 that lead to wrong orders being listed in the Picking app.
* Fixes the stretching of images on barcode labels.

### de

* Bereitet das Plugin für Version 4.4.0 der Versand-App sowie für Version 4.1.0 der Lager-App vor.
* Behebt einen Fehler in der REST API in Shopware Versionen vor 5.2.8, der dazu führte, dass in der Versand-App falsche Bestellungen angezeigt wurden.
* Behebt ein Problem beim Strecken von Bildern auf Barcode-Etiketten.

## 4.5.2

### en

* Fixes an error that might have occurred when creating return shipments in the Inventory App (requires at least version 4.0.26 of plugin "Shopware ERP powered by Pickware").

### de

* Behebt einen Fehler, der unter Umständen beim Erstellen von Rücksendungen in der Lager-App auftrat (benötigt mindestens Version 4.0.26 des Plugins "Shopware ERP powered by Pickware").


## 4.5.1

### en

* Fixes an error that occurred when printing bin-location and picking-box barcode labels.

### de

* Behebt einen Fehler, der beim Druck von Lagerplatz- und Komissionierkistenetiketten auftrat.


## 4.5.0

### en

* Barcode label printing:
    * EANs are now printed as actual EAN-format barcodes.
    * Adds barcode-less label templates.
    * Adds additional template variables.
    * Adds templates with half-length barcodes.
* Contains changes that allow selecting a default bin location in the Inventory app (from app version 4.1.0).

### de

* Barcode-Etikettendruck:
    * EAN-Barcodes werden jetzt im EAN-Barcodeformat ausgegeben.
    * Fügt Etikettenvorlagen ohne Barcodes hinzu.
    * Fügt weitere Template-Variablen hinzu.
    * Fügt Vorlagen mit Barcodes auf halber Breite hinzu.
* Enthält Anpassungen, die es ermöglichen direkt in der Lager-App den Standardlagerplatz auszuwählen (ab App–Version 4.1.0).


## 4.4.1

### en

* Works around a problem in the "Custom Products" plugin that prevented orders from being opened.

### de

* Fügt ein Workaround für ein Problem im Plugin "Custom Products" hinzu, welches dazu führte, dass Bestellungen nicht geöffnet werden konnten.


## 4.4.0

### en

* Allows the customization of size, layout and content of product labels (Items > Barcode label printing > Barcode label configuration).

### de

* Ermöglicht es Größe, Layout und Inhalt von Artikel-Etiketten individuell zu gestalten (Artikel > Etiketten > Etikettenkonfigurator).


## 4.3.0

### en

* Fixes an issue that prevented an additional invoice from being printed for export documents.
* Fixes a bug that, based on the stock filter configuration, falsely prevented some orders from being listed in the Picking app.
* Improves compatibility with Shopware 5.4.
* Improves compatibility with the plugin "Set Articles".

### de

* Behebt ein Problem, das dazu führte, dass die zusätzliche Rechnung für Exportdokumente nicht gedruckt wurde.
* Behebt einen Fehler, der in Abhängigkeit von der Konfiguration des bestandsbasierten Bestellfilters dazu führte, dass manche Bestellungen fälschlicherweise nicht in der Versand-app angezeigt wurden.
* Verbessert die Kompatibilität mit Shopware 5.4.
* Verbessert die Kompatibilität mit dem Plugin "Stücklisten".


## 4.2.3

### en

* Fixes a bug that caused orders to show up in the Picking app even though they are marked as "not visible" in the Shopware backend.

### de

* Behebt einen Fehler, der dazu führte, dass Bestellungen in der Versand-App angezeigt wurden, obwohl sie im Shopware-Backend als "nicht sichtbar" markiert waren.


## 4.2.2

### en

* Fixes a bug that broke the order search for creating returns in the Inventory app.

### de

* Behebt einen Fehler, der in der Lager-App das Durchsuchen von Bestellungen zum Erfassen von Rücksendungen verhinderte.


## 4.2.1

### en

* Improves compatibility with Shopware 5.4.

### de

* Verbessert die Kompatibilität mit Shopware 5.4.


## 4.2.0

### en

* Improves compatibility with Shopware 5.4.
* Fixes a bug that caused outgoing stock entries to be written twice for Pickware POS click & collect orders which were picked using the Picking App.
* Improves the stocktake export to not display a purchase price for stock entries that didn't change the stock.
* Fixes a bug in the stocktake export that caused faulty exports for entries whose associated user account did not exist anymore.

### de

* Verbessert die Kompatibilität mit Shopware 5.4.
* Behebt einen Fehler, durch den bei Pickware POS Click & Collect-Bestellungen, die mit der App "Pickware Versand" kommissioniert wurden, Bestände doppelt ausgebucht wurden.
* Verbessert den Inventurexport, sodass Bestandseinträge, die den Bestand nicht verändert haben, nun ohne Einkaufspreis gelistet werden.
* Behebt einen Fehler im Inventurexport, der dazu führte, dass Einträge nicht korrekt exportiert wurden, wenn ein Benutzeraccount nicht mehr existierte.


## 4.1.7

### en

* Fixes a bug that prevented items of Pickware POS Click & Collect orders from being marked as shipped correctly.
* Improves the performance of loading orders for batch picking.

### de

* Behebt einen Fehler, der dazu führte, dass beim gleichzeitigen Einsatz von Pickware POS Positionen von Click & Collect Bestellungen noch korrekt als versandt markiert wurden.
* Verbessert die Geschwindigkeit beim Laden von Bestellungen für die Sammel- und Rollende Kommissionierung.


## 4.1.6

### en

* Fixes an issue that might cause some boxes to not be assigned orders when box picking in rare situations.

### de

* Behebt ein Problem, durch das in wenigen Randfällen einigen Kisten bei der rollenden Kommissionierung keine Bestellungen zugewiesen wurden.


## 4.1.5

### en

* Prevents multiple users from being assigned the same orders when they start batch picking or box picking at the same time.

### de

* Verhindert, dass mehreren Benutzern, die gleichzeitig die Sammelkommissionierung oder die rollende Kommissionierung starten, dieselben Bestellungen zur Kommissionierung zugewiesen werden.


## 4.1.4

### en

* Fixes a bug that prevented delivery confirmation emails from being sent when no shipping adapter is configured.
* Employs a workaround for compatibility issues caused by the Shopware Security plugin, which occurred during the installations and update process of Pickware Mobile.


### de

* Behebt einen Fehler, durch den die Versandbestätigungs-E-Mail nicht verschickt wurde, wenn kein Versandadapter konfiguriert war.
* Behebt durch das Shopware Security Plugin verursachte Kompatibilitätsprobleme, die während der Installation und dem Update von Pickware Mobile auftraten.


## 4.1.3

### en

* Fixes a bug that caused the license check to fail.

### de

* Behebt einen Fehler bei der Lizenzprüfung.


## 4.1.2

### en

* Fixes a bug that prevented order invoice amounts from being updated after a return was logged using the Inventory app.

### de

* Behebt einen Fehler, der dazu führte, dass die Rechnungsbeträge einer Bestellung nicht aktualisiert wurden, nachdem eine Rücksendung über die Lager-App erfasst wurde.


## 4.1.1

### en

**Note: This plugin version requires at least version 4.0.4 of the plugin "Shopware ERP powered by Pickware" to be installed.**

* Fixes an error that might have occurred when loading the orders in the Shipping app.

### de

**Hinweis: Um diese Version von Pickware Mobile installieren zu können, muss mindestens Version 4.0.4 des Plugins "Shopware ERP powered by Pickware" installiert sein.**

* Behebt einen Fehler beim Laden von Bestellungen in der Versand-App.


## 4.1.0

### en

* Adds the report "Picking and packing".
* Improves the performance of loading the orders in the Shipping app for certain database versions.
* Fixes a bug that resulted in too many stock entries as well as wrong available stock when marking a picked order as partly/completely "shipped" via the Shopware backend.

### de

* Fügt die Auswertung "Picken und Packen" hinzu.
* Verbessert die Geschwindigkeit des Ladens der Bestellungen in der Versand-App für bestimmte Datenbanken.
* Behebt einen Fehler, der dazu führte, dass zu viele Bestandseinträge geschrieben wurden sowie der verfügbare Bestand falsch angepasst wurde, wenn eine kommissionierte Bestellung über das Shopware Backend als "Komplett ausgeliefert" oder "Teilweise ausgeliefert" markiert wurde.


## 4.0.5

### en

* Improves the performance of loading the orders in the Shipping app for certain database versions.

### de

* Verbessert die Geschwindigkeit des Ladens der Bestellungen in der Versand-App für bestimmte Datenbanken.


## 4.0.4

### en

* Fixes filtering of returns in the "Return ratio" report.
* Improve precision of return ratios in the "Return ratio" report.
* Fixes missing text messages in reshipment document creation dialog.
* Fixes switched labels for the options "At least one item must have some stock" and "All released items must be fully in stock" for configuration item "Filter orders based on stock".

### de

* Behebt einen Fehler beim Filtern von Retouren in der Auswertung "Retourenquote".
* Erhöht die angezeigte Genauigkeit der Retourenquote in der Auswertung "Retourenquote".
* Korrigiert fehlende Texthinweise beim Erstellen von Retourendokumenten.
* Korrigiert im Konfigurationsfeld "Bestellfilter nach Bestand" vertauschte Beschriftungen der Auswahlmöglichkeiten "Mind. ein Artikel muss teilweise auf Lager sein" und "Alle erschienenen Artikel müssen komplett auf Lager sein".


## 4.0.3

### en

* Fixes an issue that caused the apps to always show the pictures of the main variant for all variants of a product.

### de

* Behebt das Problem, dass bei Variantenartikeln für alle Varianten in den Apps nur die Bilder der Hauptvariante angezeigt wurden.


## 4.0.2

### en

* Fixes a compatibility issue with Pickware POS that prevented non-stock-managed articles such as gift vouchers from being sold at the POS.

### de

* Behebt ein Kompatibilitätsproblem mit Pickware POS, durch das nicht-bestandsgeführte Artikel wie Geschenkgutscheine nicht mehr an der Kasse verkauft werden konnten.


## 4.0.1

### en

* Temporarily hides non-stock-managed products from version 4.0.0 of the Stocking app.

### de

* Entfernt nicht bestandsgeführte Artikel vorübergehend aus Suchergebnissen der Lager-App in Version 4.0.0.


## 4.0.0

### en

**Note: This plugin version requires at least version 4.0.0 of the plugin "Shopware ERP powered by Pickware" to be installed.**

* Adds support for chaotic warehousing (this means that one product can be stored on multiple bin locations within the same warehouse).


### de

**Hinweis: Um diese Version von Pickware Mobile installieren zu können, muss mindestens Version 4.0.0 des Plugins "Shopware ERP powered by Pickware" installiert sein.**

* Ermöglicht die chaotische Lagerhaltung (ein Artikel kann  auf mehreren Lagerplätzen innerhalb eines Lagers liegen).


## 1.1.51

### en

* Fixes a bug in subshop-filtering in the "Return ratio" report.

### de

* Behebt einen Fehler im Subshop-Filter der Auswertung "Retourenquote".

## 1.1.50


### en

* Fixes a bug in the "Return ratio" report in Shopware 5.3.4.

### de

* Behebt einen Fehler in der Auswertung "Retourenquote" in Shopware 5.3.4.


## 1.1.49

### en

* Adds the "Return ratio" report.

### de

* Fügt Auswertung "Retourenquote" hinzu.


## 1.1.48

### en

 * Improves the English translation of the plugin configuration.
 * Allows creating bin locations with the same code in different warehouses when using the Stocking app.

### de

 * Verbessert die Englische Übersetzung der Pluginkonfiguration.
 * Ermöglicht das Anlegen von Lagerplätzen mit derselben Bezeichnung in verschiedenen Lagern aus der Lager-App.


## 1.1.47

### en

* Adds an English translation for the plugin configuration.

### de

* Fügt Englische Übersetzungen der Pluginkonfiguration hinzu.


## 1.1.46

### en

* Fixes an error that occurred when loading the backend order list on Shopware versions prior to 5.2.15.

### de

* Behebt einen Fehler beim Laden der Bestellliste im Backend unter Shopware-Versionen vor 5.2.15.


## 1.1.45

### en

* Fixes broken barcode label PDF output (Shopware 5.3).

### de

* Behebt einen Fehler, der zu einer fehlerhaften Ausgabe im Etikettendruck führte (Shopware 5.3).


## 1.1.44

### en

* Fixes a bug that caused the automatically sent dispatch status emails to sometimes use the wrong text for partial shipments.
* Fixes a bug that occurred when sorting the backend order list by return status (Shopware 5.3).

### de

* Behebt einen Fehler, der dazu führte, dass die automatischen Versand-E-Mails für Teillieferungen in manchen Fällen einen falschen Text enthielten.
* Behebt einen Fehler beim Sortieren der Liste der Bestellungen im Backend nach Rücksendestatus (Shopware 5.3).


## 1.1.43

### en

* Improves the performance of loading supplier orders and products in the Inventory app.

### de

* Verbessert die Geschwindigkeit beim Laden von Lieferantenbestellungen und Artikeln in der Lager-App.


## 1.1.42

### en

**Attention:** This update requires Pickware ERP 3.2.43 or newer.

* Adds missing thumbnail quality settings to the media album of returns.
* Improves compatibility with Pickware POS.

### de

**Achtung:** Diese Version benötigt Pickware ERP 3.2.43 oder neuer.

* Ergänzt die fehlende Konfiguration der Thumbnail Qualität des Medien Albums für Rücksendungen.
* Verbessert die Kompatibilität mit Pickware POS.


## 1.1.41

### en

* Fixes a bug in the display of photos of returns in the Shopware backend.

### de

* Behebt einen Fehler in der Anzeige der Fotos einer Retoure im Shopware Backend.


## 1.1.40

### en

* Fixes an issue with the selection of the order positions to pick.

### de

* Behebt einen Fehler bei der Auswahl der zu kommissionierenden Bestellpositionen.


## 1.1.39

### en

* Improves compatibility with other Pickware plugins. In particular, this release is required for compatibility with the next version of Pickware POS.

### de

* Verbessert die Kompatibilität mit anderen Pickware Plugins. Insbesondere ist diese Aktualisierung erforderlich, um die Kompatibilität mit dem nächsten Release von Pickware POS sicherzustellen.


## 1.1.38

### en

* Fixes a number of display problems in the order list view, including the picking list filter icon not working correctly.

### de

* Behebt Anzeigefehler in der Bestellübersicht, unter anderen wird die Funktion des Bestellfilter-Icons wieder hergestellt.


## 1.1.37

### en

* Fixes a Shopware 5.3 compatibility issue that occurs when generating bar code labels.

### de

* Behebt ein Shopware 5.3-Kompatibilitätsproblem bei der Erzeugung von Barcode-Etiketten.


## 1.1.36

### en

* Fixes a problem with downloading bar code label PDFs, which occurred for some users depending on server configuration.
* Fixes an issue that occurred when opening the bar code label printing view after a customer group was deleted.

### de

* Behebt ein Problem beim Herunterladen von PDFs mit Barcode-Etiketten, das abhängig von der Serverkonfiguration bei einigen Nutzern auftrat.
* Behebt einen Fehler, der beim Öffnen des Barcode-Etikettendrucks auftrat, nachdem eine Kundengruppe gelöscht wurde.


## 1.1.35

### en

* Fixes an error that occurred when opening the barcode label printing.

### de

* Behebt einen Fehler, der beim Öffnen des Barcode-Label-Drucks auftrat.


## 1.1.34

### en

* Choose which customer groups prices are printed on barcode labels.
* Prevents sending of empty order update emails.
* Improves the usability of the partial cancellation dialog of the
reshipments tab of the order detail window.
* Adds a new column "tax" to the partial cancellation dialog of the
reshipments tab of the order detail window. The tax of optional positions is now editable.

### de

* Kundengruppe für Preise für das Barcode-Label-Drucken auswählbar.
* Behebt einen Fehler, dass leere Bestell-Status E-Mails versendet werden.
* Verbessert die Darstellung und Usability des Dialogs zur Erstellung von (Teil-)Stornorechnungen im Tab "Rücksendungen" des Bestell-Detail Fensters.
* Erweitert den Dialog zur Erstellung von (Teil-)Stornorechnungen im Tab "Rücksendungen" des Bestell-Detail Fensters um die Spalte "Steuer". Für optionale Positionen kann nun der MwSt-Satz ausgewählt werden.

## 1.1.33

### en

* Fixes a compatibility issue with Shopware versions older than 5.2.15 that occurred when filtering orders by return order status.

### de

* Behebt ein Kompatibilitätsproblem mit Shopware-Versionen vor 5.2.15, das beim Filtern von Bestellungen nach Rücksendungsstatus auftrat.


## 1.1.32

### en

* Fixes a migration performance issue that prevented some customers from updating from version 1.1.26.

### de

* Behebt ein Performanceproblem beim Update von Version 1.1.26 auf neuere Versionen, das bei einzelnen Kunden zum Abbruch des Updates führen konnte.


## 1.1.31

### en

* Improves the compatibilty with other Pickware plugins

### de

* Verbessert die Kompatiblität zu anderen Pickware Plugins


## 1.1.30

### en

* Fixes several UI bugs in the backend extensions.

### de

* Behebt einige Anzeigefehler in den Backend-Erweiterungen.


## 1.1.29

### en

* Improves the migration of orders having returns.

### de

* Verbessert die Migration von Bestellungen, für die Rücksendungen existieren.


## 1.1.28

### en

* Fixes a bug in the plugin's update method.

### de

* Behebt einen Fehler in der Update Methode des Plugins.


## 1.1.27

### en

**Note: This plugin version requires at least version 3.2.35 of the "Shopware ERP powered by Pickware" plugin to be installed.**

* Improves the naming of the configuration options of the Picking app order filter
* Improves the Picking app order filter by splitting up the option "All items must have stock >= ordered quantity" into two options "All released items must be completely on stock" and "All items must be completely on stock" (more info in the [documentation](https://docs.google.com/document/d/1fQtOTfL1DNNWsHeNToee96szfhk5g7TtR1ceOoHM_Ms))
* Adds returns their own status that can be changed in the backend
* Improves the returns UI in the backend
* Adds the backend order list a column "Returns" as well as a resepctive filter item to allow sorting and filtering the orders by their return status
* Contains a workaround for a bug in shopware that would save the whole order when saving any of the order comments using the respective buttons

### de

**Hinweis: Um diese Plugin-Version installieren zu können, muss mindestens Version 3.2.35 des "Shopware ERP powered by Pickware" Plugins installiert sein.**

* Verbessert die Bennung der Konfigurationsoptionen des Bestellungen-Filters der Versand-App
* Verbessert den Bestellungen-Filter der Versand-App, indem die Option "Alle Artikel müssen Bestand >= bestellte Menge haben" in zwei Optionen "Alle erschienenen Artikel müssen komplett auf Lager sein" und "Alle Artikel müssen komplett auf Lager sein" aufgetrennt wurde (weitere Infos in der [Dokumentation](https://www.pickware.de/dokumentation/pickware-mobile)
* Fügt den Rücksendungen einen eigenen Status hinzu, der im Backend geändert werden kann
* Verbessert die Darstellung der Rücksendungn im Backend
* Fügt der Liste der Bestellungen im Backend einen Spalte "Rücksendungen" sowie einen entsprechenden Filter hinzu, um nach dem Rücksende-Status sortieren und filtern zu können
* Umgeht einen Fehler in shopware der dazu führte, dass das Speichern der Kommentare zu einer Bestellung über die entsprechenden Buttons die gesamte Bestellung gespeichert hat


## 1.1.26

### en

* Improves the compatibility with the Picking and Inventory apps

### de

* Verbessert die Kompatibilität mit den Versand und Lager-Apps


## 1.1.25

### en

* Fixes a bug that might have prevented reserved stock from being freed once the picking of an order was completed

### de

* Behebt einen Fehler der unter Umständen dazu führte, dass reservierter Bestand nicht freigegeben wurde, sobald die Kommissionierung einer Bestellung abgeschlossen wurde


## 1.1.24

### en

**Note: This plugin version requires at least version 3.2.31 of the "Shopware ERP powered by Pickware" plugin to be installed.**

* Fixes an error that might have occurred when starting to pick an order in the Picking app

### de

**Hinweis: Um diese Plugin-Version installieren zu können, muss mindestens Version 3.2.31 des "Shopware ERP powered by Pickware" Plugins installiert sein.**

* Behebt einen Fehler der unter Umständen zu Beginn der Kommissionierung in der Versand-App auftrat


## 1.1.23

### en

* Fixes a bug that might caused order items to show up twice in the Picking app

### de

* Behebt einen Fehler der unter Umständen dazu führte, dass Bestellpositionen zweimal in der Versand-App angezeigt wurden


## 1.1.22

### en

* Fixes an error which caused the stock not being updated correctly for partial deliveries

### de

* Behebt einen Fehler der dazu führte, dass bei Teillieferungen der Bestand nicht korrekt aktualisiert wurde


## 1.1.21

### en

**Note: This plugin version requires at least version 3.2.29 of the "Shopware ERP powered by Pickware" plugin to be installed.**

* Drastically improves the performance when loading orders in the Picking app (in combination with the latest releases of the Pickware shipping adapters)
* Improves the Picking order filter to not consider stock as available, if orders that are already being picked require that stock
* Fixes a bug in the Picking order filter that might have caused orders to temporarily disappear from the app, while being picked

### de

**Hinweis: Um diese Plugin-Version installieren zu können, muss mindestens Version 3.2.29 des "Shopware ERP powered by Pickware" Plugins installiert sein.**

* Verbessert die Geschwindigkeit beim Laden der Bestellungen in der Versand-App erheblich (in Kombination mit den aktuellsten Versionen der Pickware Versandadpter)
* Verbessert den Bestellungenfilter für die Versand-App, sodass der benötigte Bestand von Bestellungen, die sich in der Kommissionierung befinden, nicht mehr als verfügbar angenommen wird
* Behebt einen Fehler im Bestellungenfilter der dazu führte, dass Bestellungen unter Umständen vorübergehend nicht in der Versand-App angezeigt wurden, während sie kommissioniert wurden


## 1.1.20

### en

* Improves the handling of documents in the Picking app

### de

* Verbessert die Handhabung von Dokumenten in der Versand-App


## 1.1.19

### en

* Customers can now be notified via email upon receiving their return shipment (must be enabled in the plugin config)
* Fixes an error that could result in very large API logs

### de

* Kunden können nun automatisch per E-Mail benachrichtigt werden, sobald ihre Retouren eingegangen sind (muss in der Plugin-Konfiguration aktiviert werden)
* Behebt einen Fehler, der zu sehr großen API-Logs führen konnte


## 1.1.18

### en

* Adds two config fields for specifying documents that shall be created and printed by the Picking app when it creates invoices or delivery notes (from version 3.6.0 of the Picking app)
* Includes changes that allow an improved, document based printer configuration in the Picking App (from version 3.6.0 of the Picking app)

### de

* Fügt der Plugin-Konfiguration zwei neue Felder hinzu, um Dokumente zu spezifizieren, welche von der Versand-App zusätzlich erstellt und gedruckt werden, wenn Rechnung oder Lieferscheine erstellt werden (ab Version 3.6.0 der Versand-App)
* Enthält Anpassungen, die eine verbesserte, Dokumenten-basierte Drucker-Konfiguration in der Versand-App erlauben (ab Version 3.6.0 der Versand-App)


## 1.1.17

### en

* Fixes a stock inconsistency when returning stock into a warehouse which is set as "stock not available in the frontend".

### de

* Behebt ein Problem mit inkonsistenten Lagerbeständen bei der Einlagerung von Retouren in ein getrenntes Lager, dessen Bestand nicht für den Shop verfügbar sein soll.


## 1.1.16

### en

* Prepares to support the pre-collecting picking processes in the Picking app

### de

* Bereitet die Unterstützung der Sammelkommissionierung in der Versand-App vor


## 1.1.15

### en

* Prepares Pickware Mobile to support pre-collecting picking processes.
* Improves compatibility with console commands. This fixes an issue with cache warming.

### de

* Bereitet die Unterstützung der Sammelkommissionierung vor.
* Verbessert die Kompatibilität mit Konsolenbefehlen. Dies behebt ein Problem beim Cache Warming.


## 1.1.14

### en

* Improves the compatibilty with other Pickware plugins

### de

* Verbessert die Kompatiblität zu anderen Pickware Plugins


## 1.1.13

### en

* Improves the compatibilty with other Pickware plugins

### de

* Verbessert die Kompatiblität zu anderen Pickware Plugins


## 1.1.12

### en

* Fixes a bug that caused the backend order list to not load properly in some cases

### de

* Behebt einen Fehler der dazu führte, dass in bestimmten Fällen die Lister der Bestellungen im Backend nicht geladen wurde


## 1.1.11

### en

* Improves label selection for printing (especially if many labels need to be printed).

### de

* Vereinfacht die Auswahl der zu druckenden Etiketten (im besonderen beim Druck vieler Etiketten).


## 1.1.10

### en

* Fixes a bug that prevented some orders from being picked in the Shipping app

### de

* Behebt einen Fehler der unter Umständen dazu führte, dass eine Bestellung in der Versand-App nicht gepickt werden konnte


## 1.1.9

### en

* Improves the compatibility with other Pickware plugins

### de

* Verbessert die Kompatiblität zu anderen Pickware Plugins


## 1.1.8

### en

* Improves the creation of relocations from within the Inventory app

### de

* Verbessert die Erstellung von Umlagerungen aus der Lager-App


## 1.1.7

### en

* Fixes HTTP 503 issue when printing bar code labels.

### de

* Behebt einen HTTP 503-Fehler beim Barcode-Etikettendruck.

## 1.1.6

### en

**Note: This plugin version requires at least version 3.2.3 of the "Shopware ERP powered by Pickware" plugin to be installed.**

* Fixes an issue when opening the print barcode labels dialog.

### de

**Hinweis: Um diese Plugin-Version installieren zu können, muss mindestens Version 3.2.3 des "Shopware ERP powered by Pickware" Plugins installiert sein.**

* Behebt ein Problem beim Öffnen des Fensters Etikettendruck.


## 1.1.5

### en

* Fixes a bug in the reshipments handling.
* Fixes a bug that broke marking articles for barcode printing.
* Fixes pagination in stocktake report.

### de

* Behebt einen Fehler in der Verarbeitung von Retouren.
* Behebt einen Fehler, der das Markieren von Artikeln zum Barcodedruck verhinderte.
* Behebt einen Paginierungsfehler im Inventurexport.

## 1.1.4

### en

* Fixes a compatibility issue in the release before.

### de

* Behebt ein Kompatibilitätsproblem in der vorherigen Version.


## 1.1.3

### en

* Fixes a compatibility issue between different versions of Pickware Mobile and Pickware POS.

### de

* Behebt ein Kompatibilitätsproblem zwischen verschiedenen Versionen von Pickware Mobile und Pickware POS.


## 1.1.2

### en

* Fixes some problems with barcode printing.

### de

* Behebt einige Probleme beim Barcode-Druck.


## 1.1.1

### en

* Removes stale JavaScript sources that were causing issues for some customers.

### de

* Behebt ein Problem, das durch veraltete JavaScript-Dateien hervorgerufen wurde.


## 1.1.0

### en

**Note: This plugin version requires at least version 3.1.0 of the "Shopware ERP powered by Pickware" plugin to be installed.**

* Prepares this plugin for Pickware 3.1, which includes the support of mutliple warehouses

### de

**Hinweis: Um diese Plugin-Version installieren zu können, muss mindestens Version 3.1.0 des "Shopware ERP powered by Pickware" Plugins installiert sein.**

* Bereitet das Plugin für Pickware 3.1 vor, das die Unterstützung für mehrere Lager enthält


## 1.0.26

### en

* Fixes a bug, which caused the maximum number of orders displayed in the Picking app to always be 1000

### de

* Behebt einen Fehler der dazu führte, dass in der Versand-App immer maximal 1000 Bestellungen angezeigt wurden


## 1.0.25

### en

* Improves the compatibility with other Pickware plugins

### de

* Verbessert die Kompatibilität mit anderen Pickware plugins

