<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareMobile\Classes\ApiRequestCompatibility;

use Shopware\Plugins\ViisonPickwareCommon\Classes\ApiRequestCompatibility\Layer;

class Orders20181204 extends Layer
{
    /**
     * @inheritdoc
     */
    public function getVersion()
    {
        return '2018-12-04';
    }

    /**
     * Removes any 'pickware' sort param from the request parameters.
     *
     * pre GET /api/orders
     */
    public function preIndexAction()
    {
        $sort = $this->request->getParam('sort');
        if ($sort === 'pickware') {
            $this->request->setParam('sort', []);
        }
    }
}
