<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareMobile\Classes\ApiRequestCompatibility;

use Shopware\Plugins\ViisonPickwareCommon\Classes\ApiRequestCompatibility\Layer;

class Orders20190111 extends Layer
{
    /**
     * @inheritdoc
     */
    public function getVersion()
    {
        return '2019-01-11';
    }

    /**
     * pre POST /api/orders/{id}/shippingDocuments
     */
    public function prePostShippingDocumentsAction()
    {
        // Replace "empty" package dimensions (i.e. all zero values) with `null`, since they are only sent in case the
        // Picking app does not present the respective fields. This works around a problem caused by a new validation
        // introduced to the DHL webservice on March 24th 2019.
        $package = $this->request->getParam('package', []);
        if (is_array($package['dimensions']) && $package['dimensions']['length'] === 0 && $package['dimensions']['width'] === 0 && $package['dimensions']['height'] === 0) {
            $package['dimensions'] = null;
            $this->request->setParam('package', $package);
        }
    }
}
