<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareMobile\Classes\ApiRequestCompatibility;

use Shopware\Plugins\ViisonPickwareCommon\Classes\ApiRequestCompatibility\Layer;

class Orders20190328 extends Layer
{
    /**
     * @inheritdoc
     */
    public function getVersion()
    {
        return '2019-03-28';
    }

    /**
     * post PUT /api/orders/{id}/lock
     */
    public function postPutLockAction()
    {
        $data = $this->view->data;
        if (!is_array($data) || !is_array($data['order'])) {
            return;
        }

        foreach ($data['order']['details'] as &$orderDetail) {
            // Until ViisonPickwareERP version 5 the shipped value was reduced when a return shipment was created. This
            // semantic has been removed in ViisonPickwareERP version 6.
            $orderDetail['shipped'] = $orderDetail['shipped'] - $orderDetail['pickwareReturnedQuantity'];

            // Until ViisonPickwareERP version 5 return shipments were cancelled immediately after their creation.
            // Cancelling a return shipment position reduces the quantity counter of the corresponding order detail.
            // In ViisonPickwareERP 6 there can be a return shipment that has been created but not cancelled yet. For each
            // order detail in this state a cancellation of the orderDetail is faked by reducing the quantity by
            // the number of item returned but not cancelled
            // (pickwareReturnedQuantity - pickwareCancelledReturnedQuantity).
            $orderDetail['quantity'] = $orderDetail['quantity'] - $orderDetail['pickwareReturnedQuantity'] + $orderDetail['pickwareCancelledReturnedQuantity'];
        }
        unset($orderDetail);

        $this->view->data = $data;
    }

    /**
     * pre POST /api/orders/{id}/returnShipments
     */
    public function prePostReturnShipmentsAction()
    {
        $items = $this->request->getParam('items');
        if (!is_array($items)) {
            return;
        }

        foreach ($items as &$item) {
            // In ViisonPickwareERP version 6 the property "depreciatedQuantity" was renamed to "writtenOffQuantity"
            $item['writtenOffQuantity'] = $item['depreciatedQuantity'];
            unset($item['depreciatedQuantity']);
        }
        unset($item);

        $this->request->setParam('items', $items);
    }

    /**
     * post POST /api/orders/{id}/returnShipments
     */
    public function postPostReturnShipmentsAction()
    {
        $data = $this->view->data;

        if (!is_array($data) || !is_array($data['items'])) {
            return;
        }

        foreach ($data['items'] as &$itemData) {
            // In ViisonPickwareERP version 6 the property "depreciatedQuantity" was renamed to "writtenOffQuantity"
            $itemData['depreciatedQuantity'] = $itemData['writtenOffQuantity'];
            unset($itemData['writtenOffQuantity']);
        }
        unset($itemData);

        $this->view->data = $data;
    }
}
