<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareMobile\Classes\ApiRequestCompatibility;

use Shopware\Plugins\ViisonPickwareCommon\Classes\ApiRequestCompatibility\Layer;

class Orders20191014 extends Layer
{
    /**
     * @inheritdoc
     */
    public function getVersion()
    {
        return '2019-10-14';
    }

    /**
     * Updates all article details of order items contained in the response data by replacing their `purchaseUnit` with
     * string ` .0`, if it was `null`. This is a hotfix for version 5.7.0 of the Picking app, which might crash on
     * iOS >= 13.1 if it receives `null` for a `purchaseUnit`.
     *
     * post GET /api/orders
     */
    public function postIndexAction()
    {
        $data = $this->view->data;
        if (!is_array($data)) {
            return;
        }

        foreach ($data as &$order) {
            foreach ($order['details'] as &$orderDetail) {
                if ($orderDetail['articleDetail']['purchaseUnit'] === null) {
                    $orderDetail['articleDetail']['purchaseUnit'] = ' .0';
                }
            }
        }
        unset($orderDetail);
        unset($order);

        $this->view->data = $data;
    }

    /**
     * Updates all article details of order items contained in the response data by replacing their `purchaseUnit` with
     * string ` .0`, if it was `null`. This is a hotfix for version 5.7.0 of the Picking app, which might crash on
     * iOS >= 13.1 if it receives `null` for a `purchaseUnit`.
     *
     * post PUT /api/orders/{id}/lock
     */
    public function postPutLockAction()
    {
        $data = $this->view->data;
        if (!is_array($data) || !is_array($data['order'])) {
            return;
        }

        foreach ($data['order']['details'] as &$orderDetail) {
            if ($orderDetail['articleDetail']['purchaseUnit'] === null) {
                $orderDetail['articleDetail']['purchaseUnit'] = ' .0';
            }
        }
        unset($orderDetail);

        $this->view->data = $data;
    }
}
