<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareMobile\Classes\ApiRequestCompatibility;

use Shopware\Plugins\ViisonPickwareCommon\Classes\ApiRequestCompatibility\Layer;

class SupplierOrders20191014 extends Layer
{
    /**
     * @inheritdoc
     */
    public function getVersion()
    {
        return '2019-10-14';
    }

    /**
     * Updates all article details of order items contained in the response data by replacing their `purchaseUnit` with
     * string ` .0`, if it was `null`. This is a hotfix for version 5.5.0 of the Stocking app, which might crash on
     * iOS >= 13.1 if it receives `null` for a `purchaseUnit`.
     *
     * post GET /api/supplierOrders
     */
    public function postIndexAction()
    {
        $data = $this->view->data;
        if (!is_array($data)) {
            return;
        }

        foreach ($data as &$order) {
            foreach ($order['items'] as &$orderItem) {
                if ($orderItem['articleDetail']['purchaseUnit'] === null) {
                    $orderItem['articleDetail']['purchaseUnit'] = ' .0';
                }
            }
        }
        unset($orderItem);
        unset($order);

        $this->view->data = $data;
    }
}
