<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareMobile\Classes\ApiRequestCompatibility;

use Shopware\Plugins\ViisonPickwareCommon\Classes\ApiRequestCompatibility\Layer;

class Variants20191014 extends Layer
{
    /**
     * @inheritdoc
     */
    public function getVersion()
    {
        return '2019-10-14';
    }

    /**
     * Updates all variants contained in the response data by replacing their `purchaseUnit` with string ` .0`, if it
     *  was `null`. This is a hotfix for version 5.5.0 of the Stocking app, which might crash on iOS >= 13.1 if it
     * receives `null` for a `purchaseUnit`.
     *
     * post GET /api/variants
     */
    public function postIndexAction()
    {
        $data = $this->view->data;
        if (!is_array($data)) {
            return;
        }

        foreach ($data as &$variant) {
            if ($variant['purchaseUnit'] === null) {
                $variant['purchaseUnit'] = ' .0';
            }
        }
        unset($variant);

        $this->view->data = $data;
    }
}
