<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareMobile\Classes\ApiRequestCompatibility;

use Shopware\Plugins\ViisonPickwareCommon\Classes\ApiRequestCompatibility\Layer;

class Warehouses20181216 extends Layer
{
    /**
     * @inheritdoc
     */
    public function getVersion()
    {
        return '2018-12-16';
    }

    /**
     * Adds a 'binLocation.' prefix to all filter properties, which don't have any prefixes, because the action's query
     * contains named joins. It is safe to use a 'binLocation.' prefix, because this is the `binLocations` resource and
     * no prefix basically means, that the filter property is part of the bin location itself.
     *
     * pre GET /api/warehouse/{id}/binLocations
     */
    public function preGetBinLocationsIndexAction()
    {
        $filter = $this->request->getParam('filter', []);
        foreach ($filter as &$filterElement) {
            if (isset($filterElement['property']) && mb_strpos($filterElement['property'], '.') === false) {
                $filterElement['property'] = 'binLocation.' . $filterElement['property'];
            }
        }
        unset($filterElement);
        $this->request->setParam('filter', $filter);
    }
}
