<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareMobile\Classes\ApiRequestCompatibility;

use Shopware\Plugins\ViisonPickwareCommon\Classes\ApiRequestCompatibility\Layer;

class Warehouses20191014 extends Layer
{
    /**
     * @inheritdoc
     */
    public function getVersion()
    {
        return '2019-10-14';
    }

    /**
     * Removes any 'stocktake' sort parameter from the request parameters.
     *
     * pre GET /api/warehouse/{id}/binLocations
     */
    public function preGetBinLocationsIndexAction()
    {
        $sort = $this->request->getParam('sort');
        if ($sort === 'stocktake') {
            $this->request->setParam('sort', []);
        }
    }

    /**
     * Updates all article details of bin location mappings contained in the response data by replacing their
     * `purchaseUnit` with string ` .0`, if it was `null`. This is a hotfix for version 5.5.0 of the Stocking app, which
     * might crash on iOS >= 13.1 if it receives `null` for a `purchaseUnit`.
     *
     * post GET /api/warehouses/{id}/binLocations
     */
    public function postGetBinLocationsIndexAction()
    {
        $data = $this->view->data;
        if (!is_array($data)) {
            return;
        }

        foreach ($data as &$binLocation) {
            foreach ($binLocation['articleDetailBinLocationMappings'] as &$binLocationMapping) {
                if ($binLocationMapping['articleDetail']['purchaseUnit'] === null) {
                    $binLocationMapping['articleDetail']['purchaseUnit'] = ' .0';
                }
            }
        }
        unset($binLocationMapping);
        unset($binLocation);

        $this->view->data = $data;
    }
}
