<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareMobile\Classes\Exceptions;

use Shopware\Plugins\ViisonCommon\Components\ExceptionTranslation\LocalizableThrowable;

/**
 * Thrown when trying to lock an order that is already locked.
 */
class OrderAlreadyLockedException extends \Exception implements LocalizableThrowable
{
    /**
     * @var string $orderNumber the number of the order which could not be locked
     */
    private $orderNumber;

    /**
     * @param string $orderNumber the number of the order which could not be locked
     */
    public function __construct($orderNumber)
    {
        $this->orderNumber = $orderNumber;
        $message = sprintf(
            'The order %s is already being picked by another user.',
            $orderNumber
        );
        parent::__construct($message);
    }

    /**
     * @inheritdoc
     */
    public function getLocalizedMessage(\Enlight_Components_Snippet_Manager $snippetManager)
    {
        $snippet = $snippetManager->getNamespace('exceptions/viison_common/main')->get('order_already_locked');

        return $snippet ? sprintf($snippet, $this->orderNumber) : $this->getMessage();
    }
}
