<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareMobile\Classes\ShippingProvider;

use \ViisonPickwareMobile_Interfaces_ShippingProvider_ShippingProvider as ShippingProvider;

trait ShippingDocumentTypeHandling
{
    /**
     * Uses the given `$shippingProvider` to calculate a globally unique ID for the passed `$documentTypeId`.
     *
     * @param int $documentTypeId
     * @param ShippingProvider $shippingProvider
     * @return int
     */
    private static function makeShippingDocumentTypeIdGloballyUnique(
        $documentTypeId,
        ShippingProvider $shippingProvider
    ) {
        // Prepare the document type ID (binary string)
        $documentTypeId = str_pad(decbin($documentTypeId), 32, '0', STR_PAD_LEFT);
        $documentTypeId = mb_substr($documentTypeId, 17);

        // Calculate a unique provider ID (binary string)
        $shippingProviderId = intval(mb_substr(sha1($shippingProvider->getIdentifier()), 0, 8), 16);
        $shippingProviderId = mb_substr(decbin($shippingProviderId), 0, 15);

        // Calculate the gloablly unique document type ID (int)
        return bindec($shippingProviderId . $documentTypeId);
    }
}
