<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareMobile\Classes\ShippingProvider;

use \ViisonPickwareMobile_Interfaces_ShippingProvider_ShippingLabelCreationResult as ShippingLabelCreationResultInterface;

/**
 * This is the default implementation of the ShippingLabelCreationResult interface,
 * which returns only empty (e.g. null) values.
 */
class ShippingLabelCreationResult implements ShippingLabelCreationResultInterface
{
    public function getNewTrackingCode()
    {
        return null;
    }

    public function getTrackingCodes()
    {
        return null;
    }

    public function getDocuments()
    {
        return [];
    }
}
