<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareMobile\Components\PickingBoxBarcodeLabel;

use Shopware\Plugins\ViisonPickwareERP\Components\BarcodeLabel\AbstractBarcodeLabelType;
use Shopware\Plugins\ViisonPickwareERP\Components\BarcodeLabel\BarcodeRenderer;
use Shopware\Plugins\ViisonPickwareERP\Components\BarcodeLabel\BarcodeLabelItemProvider;

class PickingBoxItemProvider implements BarcodeLabelItemProvider
{
    /**
     * @var BarcodeRenderer
     */
    private $barcodeRenderer;

    /**
     * @var AbstractBarcodeLabelType
     */
    private $type;

    /**
     * @var int
     */
    private $start;

    /**
     * @var int
     */
    private $end;

    /**
     * @param BarcodeRenderer $barcodeRenderer
     * @param AbstractBarcodeLabelType $type
     * @param int $start
     * @param int $end
     */
    public function __construct(
        BarcodeRenderer $barcodeRenderer,
        AbstractBarcodeLabelType $type,
        $start,
        $end
    ) {
        $this->barcodeRenderer = $barcodeRenderer;
        $this->type = $type;
        $this->start = $start;
        $this->end = $end;
    }

    /**
     * @inheritdoc
     */
    public function getContext()
    {
        return [];
    }

    /**
     * @inheritdoc
     */
    public function getItems()
    {
        $barcodeLabelsData = [];

        // Generate an array with the necessary information for each label
        for ($boxId = $this->start; $boxId <= $this->end; $boxId++) {
            // Use the box ID and prepend it with the pickware action code
            $barcodeValue = '^5' . $boxId;
            $barcodeLabelsData[] = [
                'pickingBoxNumber' => $boxId,
                'barcode' => $this->barcodeRenderer->createCode128Barcode($barcodeValue),
            ];
        }

        return $barcodeLabelsData;
    }

    /**
     * @inheritdoc
     */
    public function getType()
    {
        return $this->type;
    }
}
