<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareMobile\Components\PickingOrderFilter\OrderItemRelevance;

class OrderItemRelevanceResult
{
    /**
     * @var array
     */
    protected $relevantOrderDetailIdIndex;

    /**
     * @param int[] $relevantOrderDetailIds
     */
    public function __construct(array $relevantOrderDetailIds)
    {
        $this->relevantOrderDetailIdIndex = array_fill_keys($relevantOrderDetailIds, true);
    }

    /**
     * @param int $orderDetailId
     * @return bool true, if the given $orderDetailId is containted in this result, false otherwise.
     */
    public function isOrderDetailIdRelevant($orderDetailId)
    {
        return isset($this->relevantOrderDetailIdIndex[$orderDetailId]);
    }
}
