<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareMobile\Components;

use Shopware\Plugins\ViisonCommon\Components\HiddenConfigStorageService;

class PluginConfigService
{
    /**
     * @var HiddenConfigStorageService
     */
    private $hiddenConfigStorageService;

    /**
     * @var \Enlight_Config
     */
    private $rawPluginConfig;

    /**
     * @param HiddenConfigStorageService $hiddenConfigStorageService
     * @param \Enlight_Config $rawPluginConfig
     */
    public function __construct(HiddenConfigStorageService $hiddenConfigStorageService, \Enlight_Config $rawPluginConfig)
    {
        $this->hiddenConfigStorageService = $hiddenConfigStorageService;
        $this->rawPluginConfig = $rawPluginConfig;
    }

    /**
     * @return int[]
     */
    public function getAutomaticReturnLabelCreationDispatchMethodIds()
    {
        return $this->rawPluginConfig->toArray()['automaticReturnLabelCreationDispatchMethodIds'];
    }

    /**
     * @return bool
     */
    public function getDisplayAboutPickwareMobileWindow()
    {
        return $this->hiddenConfigStorageService->getConfigValue('pickwareWmsDisplayAboutWindow');
    }

    /**
     * @param bool $newValue
     */
    public function setDisplayAboutPickwareMobileWindow($newValue)
    {
        $this->hiddenConfigStorageService->setConfigValue(
            'pickwareWmsDisplayAboutWindow',
            'bool',
            $newValue
        );
    }

    /**
     * @return bool
     */
    public function getShowRemainingPositionsOnPartialDeliveryNote()
    {
        return (bool) $this->rawPluginConfig->get('showRemainingPositionsOnPartialDeliveryNote');
    }

    /**
     * @return string
     */
    public function getProductSortField()
    {
        return $this->rawPluginConfig->get('apiOrderItemsSortField');
    }
}
