<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareMobile\Components\QueryBuilder;

abstract class AbstractJoinQueryComponent implements QueryComponent
{
    const JOIN_OPERATOR_LEFT_JOIN = 'LEFT JOIN';
    const JOIN_OPERATOR_INNER_JOIN = 'INNER JOIN';

    /**
     * @var string
     */
    protected $joinOperator;

    /**
     * @var QueryComponent
     */
    protected $joinCondition;

    /**
     * @return string
     */
    public function getJoinOperator()
    {
        return $this->joinOperator;
    }

    /**
     * @param string $joinOperator
     */
    public function setJoinOperator($joinOperator)
    {
        $this->joinOperator = $joinOperator;
    }

    /**
     * @return QueryComponent
     */
    public function getJoinCondition()
    {
        return $this->joinCondition;
    }

    /**
     * @param QueryComponent $joinCondition
     */
    public function setJoinCondition(QueryComponent $joinCondition)
    {
        $this->joinCondition = $joinCondition;
    }

    /**
     * @inheritdoc
     */
    public function createQueryString()
    {
        return sprintf(
            "%s %s\n\tON %s",
            $this->joinOperator,
            $this->createJoiningQueryString(),
            $this->joinCondition->createQueryString()
        );
    }

    /**
     * @inheritdoc
     */
    public function getRequiredTables()
    {
        return $this->joinCondition->getRequiredTables();
    }

    /**
     * @return string The name or alias of the data source joined by this component.
     */
    abstract public function getJoiningTableName();

    /**
     * @return string A query string representing the data source that should be joined, e.g. a table name or subquery.
     */
    abstract protected function createJoiningQueryString();
}
