<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareMobile\Components\QueryBuilder;

class ComparisonQueryComponent implements QueryComponent
{
    /**
     * @var QueryComponent
     */
    protected $leftOperand;

    /**
     * @var string
     */
    protected $operator;

    /**
     * @var QueryComponent
     */
    protected $rightOperand;

    /**
     * @param QueryComponent $leftOperand
     * @param string $operator
     * @param QueryComponent $rightOperand
     */
    public function __construct(QueryComponent $leftOperand, $operator, QueryComponent $rightOperand)
    {
        $this->leftOperand = $leftOperand;
        $this->operator = $operator;
        $this->rightOperand = $rightOperand;
    }

    /**
     * @return QueryComponent
     */
    public function getLeftOperand()
    {
        return $this->leftOperand;
    }

    /**
     * @param QueryComponent $leftOperand
     */
    public function setLeftOperand(QueryComponent $leftOperand)
    {
        $this->leftOperand = $leftOperand;
    }

    /**
     * @return string
     */
    public function getOperator()
    {
        return $this->operator;
    }

    /**
     * @param string $operator
     */
    public function setOperator($operator)
    {
        $this->operator = $operator;
    }

    /**
     * @return QueryComponent
     */
    public function getRightOperand()
    {
        return $this->rightOperand;
    }

    /**
     * @param QueryComponent $rightOperand
     */
    public function setRightOperand(QueryComponent $rightOperand)
    {
        $this->rightOperand = $rightOperand;
    }

    /**
     * @inheritdoc
     */
    public function createQueryString()
    {
        return sprintf(
            '(%s %s %s)',
            $this->leftOperand->createQueryString(),
            $this->operator,
            $this->rightOperand->createQueryString()
        );
    }

    /**
     * @inheritdoc
     */
    public function getRequiredTables()
    {
        return array_merge($this->leftOperand->getRequiredTables(), $this->rightOperand->getRequiredTables());
    }
}
