<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareMobile\Components\QueryBuilder;

trait ComponentWrapping
{
    /**
     * @var QueryComponent
     */
    protected $wrappedComponent;

    /**
     * @return QueryComponent
     */
    public function getWrappedComponent()
    {
        return $this->wrappedComponent;
    }

    /**
     * @param QueryComponent $wrappedComponent
     */
    public function setWrappedComponent(QueryComponent $wrappedComponent)
    {
        $this->wrappedComponent = $wrappedComponent;
    }

    /**
     * Default implementation of {@link QueryComponent::getRequiredTables()} for wrapping components.
     *
     * @return string
     */
    public function getRequiredTables()
    {
        return $this->wrappedComponent->getRequiredTables();
    }
}
