<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareMobile\Components\QueryBuilder;

class DistinctSelectQueryComponent extends SelectQueryComponent
{
    /**
     * @inheritdoc
     */
    public function createQueryString()
    {
        return sprintf(
            'DISTINCT (%s)%s',
            $this->getWrappedComponent()->createQueryString(),
            (mb_strlen($this->alias) > 0) ? sprintf(' AS `%s`', $this->alias) : ''
        );
    }
}
