<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareMobile\Components\QueryBuilder;

class FieldDescriptorQueryComponent implements QueryComponent
{
    /**
     * @var string
     */
    protected $tableName;

    /**
     * @var string
     */
    protected $fieldName;

    /**
     * @param string $tableName
     * @param string $fieldName
     */
    public function __construct($tableName, $fieldName)
    {
        $this->tableName = $tableName;
        $this->fieldName = $fieldName;
    }

    /**
     * @return string
     */
    public function getTableName()
    {
        return $this->tableName;
    }

    /**
     * @return string
     */
    public function getFieldName()
    {
        return $this->fieldName;
    }

    /**
     * @inheritdoc
     */
    public function createQueryString()
    {
        return sprintf(
            '`%s`.`%s`',
            $this->tableName,
            $this->fieldName
        );
    }

    /**
     * @inheritdoc
     */
    public function getRequiredTables()
    {
        return [$this->tableName];
    }
}
