<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareMobile\Components\QueryBuilder;

class FunctionQueryComponent implements QueryComponent, ComponentWrapper
{
    use ComponentWrapping;

    /**
     * @var string
     */
    protected $function;

    /**
     * @param string $function
     * @param QueryComponent $wrappedComponent
     */
    public function __construct($function, QueryComponent $wrappedComponent)
    {
        $this->function = $function;
        $this->setWrappedComponent($wrappedComponent);
    }

    /**
     * @return string
     */
    public function getFunction()
    {
        return $this->function;
    }

    /**
     * @param string $function
     */
    public function setFunction($function)
    {
        $this->function = $function;
    }

    /**
     * @inheritdoc
     */
    public function createQueryString()
    {
        return sprintf('%s(%s)', $this->function, $this->getWrappedComponent()->createQueryString());
    }
}
