<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareMobile\Components\QueryBuilder;

class PlainSqlQueryComponent implements QueryComponent
{
    /**
     * @var string
     */
    protected $queryString;

    /**
     * @var string[]
     */
    protected $requiredTables;

    /**
     * @param string $queryString
     * @param string[] $requiredTables
     */
    public function __construct($queryString, array $requiredTables)
    {
        $this->queryString = $queryString;
        $this->requiredTables = $requiredTables;
    }

    /**
     * @return string
     */
    public function getQueryString()
    {
        return $this->queryString;
    }

    /**
     * @param string $queryString
     */
    public function setQueryString($queryString)
    {
        $this->queryString = $queryString;
    }

    /**
     * @inheritdoc
     */
    public function getRequiredTables()
    {
        return $this->requiredTables;
    }

    /**
     * @param string[] $requiredTables
     */
    public function setRequiredTables(array $requiredTables)
    {
        $this->requiredTables = $requiredTables;
    }

    /**
     * @inheritdoc
     */
    public function createQueryString()
    {
        return $this->queryString;
    }
}
