<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareMobile\Components\QueryBuilder;

use Exception;

class QueryBuilderException extends Exception
{
    /**
     * @return self
     */
    public static function missingSelectComponent()
    {
        return new self('Cannot create SQL string. Requring at least 1 select component. Zero given.');
    }

    /**
     * @return self
     */
    public static function missingFromTableName()
    {
        return new self('Cannot create SQL string. Requring a "from" table name. None given.');
    }

    /**
     * @param string $tableName
     * @return self
     */
    public static function tableNotAvailableForJoining($tableName)
    {
        return new self(sprintf('Table "%s" is not available for joining.', $tableName));
    }
}
