<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareMobile\Components\QueryBuilder;

class QueryComponentFactory
{
    /**
     * @param string $tableName
     * @param string $fieldName
     * @param string $alias
     * @return SelectQueryComponent
     */
    public static function createTableFieldSelectWithAlias($tableName, $fieldName, $alias)
    {
        return new SelectQueryComponent(new FieldDescriptorQueryComponent($tableName, $fieldName), $alias);
    }

    /**
     * @param string $tableName
     * @param string $fieldName
     * @return GroupByQueryComponent
     */
    public static function createGroupByTableField($tableName, $fieldName)
    {
        return new GroupByQueryComponent(new FieldDescriptorQueryComponent($tableName, $fieldName));
    }

    /**
     * @param string $tableName
     * @param string $fieldName
     * @param array $values
     * @return QueryComponent
     */
    public static function createTableFieldInValuesComparison($tableName, $fieldName, array $values)
    {
        if (count($values) > 0) {
            return new ComparisonQueryComponent(
                new FieldDescriptorQueryComponent($tableName, $fieldName),
                'IN',
                new ScalarValueQueryComponent($values)
            );
        } else {
            // MySQL failes to evaluate an IN comparison on an empty set, hence use a condition that's always
            // false instead
            return new ScalarValueQueryComponent(false);
        }
    }
}
