<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareMobile\Components\QueryBuilder;

class SubQueryJoinQueryComponent extends AbstractJoinQueryComponent
{
    /**
     * @var string
     */
    protected $joiningSubQuery;

    /**
     * @var string
     */
    protected $joinAlias;

    /**
     * @param string $joinOperator
     * @param string $joiningSubQuery
     * @param string $joinAlias
     * @param QueryComponent $joinCondition
     */
    public function __construct($joinOperator, $joiningSubQuery, $joinAlias, QueryComponent $joinCondition)
    {
        $this->joinOperator = $joinOperator;
        $this->joiningSubQuery = $joiningSubQuery;
        $this->joinAlias = $joinAlias;
        $this->joinCondition = $joinCondition;
    }

    /**
     * @return string
     */
    public function getJoiningSubQuery()
    {
        return $this->joiningSubQuery;
    }

    /**
     * @param string $joiningSubQuery
     */
    public function setJoiningSubQuery($joiningSubQuery)
    {
        $this->joiningSubQuery = $joiningSubQuery;
    }

    /**
     * @return string
     */
    public function getJoinAlias()
    {
        return $this->joinAlias;
    }

    /**
     * @param string $joinAlias
     */
    public function setJoinAlias($joinAlias)
    {
        $this->joinAlias = $joinAlias;
    }

    /**
     * @inheritdoc
     */
    public function getJoiningTableName()
    {
        return $this->joinAlias;
    }

    /**
     * @inheritdoc
     */
    protected function createJoiningQueryString()
    {
        return sprintf('(%s) AS `%s`', $this->joiningSubQuery, $this->joinAlias);
    }
}
