<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareMobile\Components\QueryBuilder;

class TableJoinQueryComponent extends AbstractJoinQueryComponent
{
    /**
     * @var string
     */
    protected $joiningTableName;

    /**
     * @param string $joinOperator
     * @param string $joiningTableName
     * @param QueryComponent $joinCondition
     */
    public function __construct($joinOperator, $joiningTableName, QueryComponent $joinCondition)
    {
        $this->joinOperator = $joinOperator;
        $this->joiningTableName = $joiningTableName;
        $this->joinCondition = $joinCondition;
    }

    /**
     * @inheritdoc
     */
    public function getJoiningTableName()
    {
        return $this->joiningTableName;
    }

    /**
     * @param string $joiningTableName
     */
    public function setJoiningTableName($joiningTableName)
    {
        $this->joiningTableName = $joiningTableName;
    }

    /**
     * @inheritdoc
     */
    protected function createJoiningQueryString()
    {
        return sprintf('`%s`', $this->joiningTableName);
    }
}
