<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareMobile\Components\QueryBuilder;

class UnaryOperationQueryComponent implements QueryComponent
{
    /**
     * @var QueryComponent
     */
    protected $leftOperand;

    /**
     * @var string
     */
    protected $operator;

    /**
     * @param QueryComponent $leftOperand
     * @param string $operator
     */
    public function __construct(QueryComponent $leftOperand, $operator)
    {
        $this->leftOperand = $leftOperand;
        $this->operator = $operator;
    }

    /**
     * @return QueryComponent
     */
    public function getLeftOperand()
    {
        return $this->leftOperand;
    }

    /**
     * @param QueryComponent $leftOperand
     */
    public function setLeftOperand(QueryComponent $leftOperand)
    {
        $this->leftOperand = $leftOperand;
    }

    /**
     * @return string
     */
    public function getOperator()
    {
        return $this->operator;
    }

    /**
     * @param string $operator
     */
    public function setOperator($operator)
    {
        $this->operator = $operator;
    }

    /**
     * @inheritdoc
     */
    public function createQueryString()
    {
        return sprintf(
            'IFNULL((%s %s), 0)',
            $this->leftOperand->createQueryString(),
            $this->operator
        );
    }

    /**
     * @inheritdoc
     */
    public function getRequiredTables()
    {
        return $this->leftOperand->getRequiredTables();
    }
}
