<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareMobile\Components\QueryComponentArrayCoding;

trait ArrayDecoding
{
    /**
     * @param array $encodedQueryComponent
     * @throws QueryComponentArrayDecodingException if the encoded type is missing or invalid.
     */
    protected function assertCodableType(array $encodedQueryComponent)
    {
        if (!isset($encodedQueryComponent['type'])) {
            throw QueryComponentArrayDecodingException::missingField(__CLASS__, 'type');
        }
        if ($encodedQueryComponent['type'] !== $this->getCodableType()) {
            throw QueryComponentArrayDecodingException::invalidType(
                __CLASS__,
                $encodedQueryComponent['type'],
                $this->getCodableType()
            );
        }
    }

    /**
     * @param array $encodedQueryComponent
     * @throws QueryComponentArrayDecodingException if the passed `$encodedQueryComponent` does not contain the field
     *         with key `$fieldName`.
     */
    protected function assertFieldExists(array $encodedQueryComponent, $fieldName)
    {
        if (!isset($encodedQueryComponent[$fieldName])) {
            throw QueryComponentArrayDecodingException::missingField(__CLASS__, $fieldName);
        }
    }
}
