<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareMobile\Components\QueryComponentArrayCoding;

use Shopware\Plugins\ViisonPickwareMobile\Components\QueryBuilder\FunctionQueryComponent;
use Shopware\Plugins\ViisonPickwareMobile\Components\QueryBuilder\QueryComponent;

class FunctionQueryComponentArrayCoder implements QueryComponentArrayCoder
{
    use ArrayDecoding;

    const CODABLE_TYPE = 'function';

    /**
     * @inheritdoc
     */
    public function getCodableType()
    {
        return self::CODABLE_TYPE;
    }

    /**
     * @inheritdoc
     */
    public function canEncodeQueryComponent(QueryComponent $queryComponent)
    {
        return $queryComponent instanceof FunctionQueryComponent;
    }

    /**
     * @inheritdoc
     */
    public function encodeToArray(QueryComponent $queryComponent, callable $encodeChildComponent)
    {
        return [
            'type' => $this->getCodableType(),
            'function' => $queryComponent->getFunction(),
            'wrappedComponent' => $encodeChildComponent($queryComponent->getWrappedComponent()),
        ];
    }

    /**
     * @inheritdoc
     */
    public function decodeFromArray(array $encodedQueryComponent, callable $decodeChildComponent)
    {
        $this->assertCodableType($encodedQueryComponent);
        $this->assertFieldExists($encodedQueryComponent, 'function');
        $this->assertFieldExists($encodedQueryComponent, 'wrappedComponent');

        return new FunctionQueryComponent(
            $encodedQueryComponent['function'],
            $decodeChildComponent($encodedQueryComponent['wrappedComponent'])
        );
    }
}
