<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareMobile\Components\QueryComponentArrayCoding;

use Shopware\Plugins\ViisonPickwareMobile\Components\QueryBuilder\QueryComponent;

interface QueryComponentArrayCoder
{
    /**
     * @return string
     */
    public function getCodableType();

    /**
     * @param QueryComponent $queryComponent
     * @return boolean
     */
    public function canEncodeQueryComponent(QueryComponent $queryComponent);

    /**
     * @param QueryComponent $queryComponent
     * @param callable $encodeChildComponent
     * @return array
     */
    public function encodeToArray(QueryComponent $queryComponent, callable $encodeChildComponent);

    /**
     * @param array $encodedQueryComponent
     * @param callable $decodeChildComponent
     * @return QueryComponent
     * @throws QueryComponentArrayDecodingException
     */
    public function decodeFromArray(array $encodedQueryComponent, callable $decodeChildComponent);
}
