<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareMobile\Components\QueryComponentArrayCoding;

use Exception;

class QueryComponentArrayDecodingException extends Exception
{
    /**
     * @param string $fieldName
     * @return self
     */
    public static function missingField($fieldName)
    {
        return new self(sprintf(
            'Cannot decode query component from array, because a required field "%s" is not set.',
            $fieldName
        ));
    }

    /**
     * @param string $className
     * @param string $givenType
     * @param string $expectedType
     * @return self
     */
    public static function invalidType($className, $givenType, $expectedType)
    {
        return new self(sprintf(
            'Cannot decode query component of type "%s" from array, because the encoded type "%s" does not match the expected type "%s".',
            $className,
            $givenType,
            $expectedType
        ));
    }

    /**
     * @param string $codableType
     * @return self
     */
    public static function componentNotDecodable($codableType)
    {
        return new self(sprintf(
            'Cannot decode query component of type "%s" from array, because no respective coder is available.',
            $codableType
        ));
    }
}
