<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareMobile\Components\QueryComponentArrayCoding;

use Exception;
use Shopware\Plugins\ViisonPickwareMobile\Components\QueryBuilder\QueryComponent;

class QueryComponentArrayEncodingException extends Exception
{
    /**
     * @param QueryComponent $queryComponent
     * @return self
     */
    public static function componentNotEncodable(QueryComponent $queryComponent)
    {
        return new self(sprintf(
            'Cannot encode query component "%s" to array, because no respective coder is available.',
            get_class($queryComponent)
        ));
    }
}
