<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareMobile\Components\QueryComponentArrayCoding;

use Shopware\Plugins\ViisonPickwareMobile\Components\QueryBuilder\QueryComponent;
use Shopware\Plugins\ViisonPickwareMobile\Components\QueryBuilder\ScalarValueQueryComponent;

class ScalarValueQueryComponentArrayCoder implements QueryComponentArrayCoder
{
    use ArrayDecoding;

    const CODABLE_TYPE = 'scalarValue';

    /**
     * @inheritdoc
     */
    public function getCodableType()
    {
        return self::CODABLE_TYPE;
    }

    /**
     * @inheritdoc
     */
    public function canEncodeQueryComponent(QueryComponent $queryComponent)
    {
        return $queryComponent instanceof ScalarValueQueryComponent;
    }

    /**
     * @inheritdoc
     */
    public function encodeToArray(QueryComponent $queryComponent, callable $encodeChildComponent)
    {
        return [
            'type' => $this->getCodableType(),
            'value' => $queryComponent->getValue(),
        ];
    }

    /**
     * @inheritdoc
     */
    public function decodeFromArray(array $encodedQueryComponent, callable $decodeChildComponent)
    {
        $this->assertCodableType($encodedQueryComponent);
        $this->assertFieldExists($encodedQueryComponent, 'value');

        return new ScalarValueQueryComponent($encodedQueryComponent['value']);
    }
}
