<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareMobile\Components\QueryComponentArrayCoding;

use Shopware\Plugins\ViisonPickwareMobile\Components\QueryBuilder\UnaryOperationQueryComponent;
use Shopware\Plugins\ViisonPickwareMobile\Components\QueryBuilder\QueryComponent;

class UnaryOperationQueryComponentArrayCoder implements QueryComponentArrayCoder
{
    use ArrayDecoding;

    const CODABLE_TYPE = 'unary_operation';

    /**
     * @inheritdoc
     */
    public function getCodableType()
    {
        return self::CODABLE_TYPE;
    }

    /**
     * @inheritdoc
     */
    public function canEncodeQueryComponent(QueryComponent $queryComponent)
    {
        return $queryComponent instanceof UnaryOperationQueryComponent;
    }

    /**
     * @inheritdoc
     */
    public function encodeToArray(QueryComponent $queryComponent, callable $encodeChildComponent)
    {
        return [
            'type' => $this->getCodableType(),
            'leftOperand' => $encodeChildComponent($queryComponent->getLeftOperand()),
            'operator' => $queryComponent->getOperator(),
        ];
    }

    /**
     * @inheritdoc
     */
    public function decodeFromArray(array $encodedQueryComponent, callable $decodeChildComponent)
    {
        $this->assertCodableType($encodedQueryComponent);
        $this->assertFieldExists($encodedQueryComponent, 'leftOperand');
        $this->assertFieldExists($encodedQueryComponent, 'operator');

        return new UnaryOperationQueryComponent(
            $decodeChildComponent($encodedQueryComponent['leftOperand']),
            $encodedQueryComponent['operator']
        );
    }
}
