<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

use Shopware\Plugins\ViisonCommon\Controllers\ViisonCommonBaseController;

class Shopware_Controllers_Backend_ViisonPickwareMobileIndexAboutPopup extends ViisonCommonBaseController
{
    /**
     * Disables the JSON renderer for getContent requests.
     */
    public function preDispatch()
    {
        if ($this->Request()->getActionName() !== 'getContent') {
            parent::preDispatch();
        }
    }

    /**
     * @inheritdoc
     */
    public function getViewParams()
    {
        return [
            'pluginName' => $this->get('plugin_manager')->get('Core')->get('ViisonPickwareMobile')->getLabel(),
        ];
    }

    /**
     * Loads the content template.
     */
    public function getContentAction()
    {
        $this->View()->loadTemplate('backend/viison_pickware_mobile_index_about_popup/view/content.tpl');
    }

    /**
     * Updates the 'displayAboutPickwareMobileWindow' config element of this plugin using the 'hideDialogInTheFuture'
     * value contained in the request.
     */
    public function saveAction()
    {
        // Save the user choice in the config element
        $showDialogInTheFuture = $this->Request()->getParam('hideDialogInTheFuture') !== 'true';
        $this->get('viison_pickware_mobile.plugin_config')->setDisplayAboutPickwareMobileWindow($showDialogInTheFuture);
    }
}
