<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareMobile\Interfaces\ShippingProvider;

use Shopware\Models\Order\Order;
use Shopware\Plugins\ViisonPickwareMobile\Classes\ShippingProvider\ReturnLabel;

interface ReturnLabelCreation extends \ViisonPickwareMobile_Interfaces_ShippingProvider_ShippingProvider
{
    /**
     * @param Order $order
     * @param float|null $weightInKg
     * @return ReturnLabel
     */
    public function createReturnLabel(Order $order, $weightInKg);
}
