<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

// Following our style guide, each class/interface definition must be part of a namespace and hence that rule must be
// disabled for this file!
// phpcs:disable PSR1.Classes.ClassDeclaration.MissingNamespace

/**
 * This interface defines a minimal set of information required to describe a single
 * shipping document, which can e.g. be part of a shipping label creation result.
 */
// Following our style guide, classes/interfaces must use CamelCase names and hence the next line must be ignored!
// phpcs:ignore Squiz.Classes.ValidClassName.NotCamelCaps
interface ViisonPickwareMobile_Interfaces_ShippingProvider_ShippingDocument
{
    /**
     * @return string A string describing the type of this document, e.g. 'exportDocument'.
     */
    public function getType();

    /**
     * @return string|int The identifier of this document, which can be used to e.g. access it via the REST API.
     */
    public function getIdentifier();

    /**
     * @return string The page size of this document, e.g. 'A4'.
     */
    public function getPageSize();

    /**
     * TODO: This Method is commented out to make this interface definition compatible with old versions of shipping
     * provider plugins. Once all shipping provider plugins have adopted the new interface for some time, we can enable
     * the method definition.
     *
     * @return int The type ID of this document.
     */
    // public function getDocumentTypeId()

    /**
     * @return string The tracking code that was created together with this document.
     */
    public function getTrackingCode();
}
