<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

// Following our style guide, each class/interface definition must be part of a namespace and hence that rule must be
// disabled for this file!
// phpcs:disable PSR1.Classes.ClassDeclaration.MissingNamespace

/**
 * This interface defines a minimal set of information required to describe a shipping document type,
 * consisting of 'id', 'name', 'pageSizeName', 'pageSizeWidth' and 'pageSizeHeight'.
 */
// Following our style guide, classes/interfaces must use CamelCase names and hence the next line must be ignored!
// phpcs:ignore Squiz.Classes.ValidClassName.NotCamelCaps
interface ViisonPickwareMobile_Interfaces_ShippingProvider_ShippingDocumentType
{
    /**
     * @return int The ID of the document type. Just use an integer that is unique in the context of the implementing
     *             plugin. Pickware takes care of making it unique in the global context.
     */
    public function getId();

    /**
     * @return string The (display) name of the documen type.
     */
    public function getName();

    /**
     * @return string The name of the document type's page size, e.g. 'DIN-A4'.
     */
    public function getPageSizeName();

    /**
     * @return float The width of the page size in millimeters, e.g. 210.0 for DIN-A4.
     */
    public function getPageSizeWidth();

    /**
     * @return float The height of the page size in millimeters, e.g. 297.0 for DIN-A4.
     */
    public function getPageSizeHeight();
}
