<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

// Following our style guide, each class/interface definition must be part of a namespace and hence that rule must be
// disabled for this file!
// phpcs:disable PSR1.Classes.ClassDeclaration.MissingNamespace

/**
 * This interface defines a minimal set of information required to describe the
 * result of a label creation in a shipping provider.
 */
// Following our style guide, classes/interfaces must use CamelCase names and hence the next line must be ignored!
// phpcs:ignore Squiz.Classes.ValidClassName.NotCamelCaps
interface ViisonPickwareMobile_Interfaces_ShippingProvider_ShippingLabelCreationResult
{
    /**
     * @return string The newly created tracking code.
     */
    public function getNewTrackingCode();

    /**
     * @return string A string of comma separated tracking codes.
     */
    public function getTrackingCodes();

    /**
     * @return array An array containing all added documents, which are of type ViisonPickwareMobile_Interfaces_ShippingProvider_ShippingDocument.
     */
    public function getDocuments();
}
