<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

// Following our style guide, each class/interface definition must be part of a namespace and hence that rule must be
// disabled for this file!
// phpcs:disable PSR1.Classes.ClassDeclaration.MissingNamespace

/**
 * This interface defines a minimal set of information required to describe a single shipping product.
 */
// Following our style guide, classes/interfaces must use CamelCase names and hence the next line must be ignored!
// phpcs:ignore Squiz.Classes.ValidClassName.NotCamelCaps
interface ViisonPickwareMobile_Interfaces_ShippingProvider_ShippingProduct
{
    /**
     * @return string The identifier of this product, which can be used to identify it by the implementing plugin.
     */
    public function getIdentifier();

    /**
     * @return string The name of this product.
     */
    public function getName();

    /**
     * @return boolean True, if this product requires package dimensions. Otherwise false.
     */
    public function packageDimensionsRequired();

    /**
     * @return array An array of option keys, which can be used to modify this product.
     */
    public function getAvailableOptions();

    /**
     * TODO: This Method is commented out to make this interface definition compatible with old versions of shipping
     * provider plugins. Once all shipping provider plugins have adopted the new interface for some time, we can enable
     * the method definition.
     *
     * @return array An associative array of dimension names (width, height, length) and their values.
     */
    // public function getDefaultPackageDimensions();
}
